#ifndef LINT
static char *rcsid="$Id: spf_config.c 435 2006-12-17 11:02:15Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif

#include <zmscanner.h>

#include "report.h"
#include "libspf_any.h"
#include "spf_config.h"

#define FILENAME "spf.conf"

static int
parse_whitelist(iprangelist_t *iprl,char *str)
{
	int rc=0;
	char *p,*q;

	DPRINT(("parse_whitelist: \"%s\"\n",str));
	if (*str == '/') return iprangelist_read(iprl,rl_type_unknown,str);
	for (p=str;p && *p;p=q) {
		while (*p && (*p == ' ' || *p == '\t')) p++;
		for (q=p;*q && (*q != ' ' && *q != '\t');q++) /*nothing*/;
		if (*q) *q++='\0'; /* else left at end of string */
		DPRINT(("parse_whitelist_line: range=\"%s\"\n",p));
		rc=iprangelist_insert(iprl,rl_type_unknown,p);
		if (rc) {
			ERRLOG((LOG_ERR,"spf: cannot insert range \"%s\"",p));
			return rc;
		}
	}
	return 0;
}

static struct _thresh {
	char *txt;
	int num;
} thresholds[] = {
	{"fail",	1},
	{"softfail",	2},
	{"none",	3},
	{"neutral",	4},
	{"pass",	5},
	{NULL,		0}
};

cfg_t *
spf_newconfig(void)
{
	cfg_t *cfg=(cfg_t*)malloc(sizeof(cfg_t));
	char localpolicy[256];
	FILE *fp;
	char buf[256];
	char fbuf[128];
	int count=0;

	if (cfg == NULL) return NULL;
	memset(cfg,0,sizeof(cfg_t));
	cfg->usetrusted=1;
	cfg->addspfheader=1;
	cfg->threshold=2; /* softfail */
	localpolicy[0]='\0';

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),FILENAME);
	DPRINT(("spf_config fn=%s\n",fbuf));
	cfg->whitelist=iprangelist_new();
	if ((fp=fopen(fbuf,"r"))) while (fgets(buf,sizeof(buf)-1,fp)) {
		char *p;
		int i;

		count++;
		if (buf[0] == '#') continue;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		while ((p >= buf) && ((*p == '\r') || (*p == '\n') ||
				      (*p == ' ') || (*p == '\t'))) *p--='\0';
		if (buf[0] == '\0') continue;
		for (p=buf;(*p != ' ') && (*p != '\t') && (*p != '\0');p++) ;
		*p++='\0';
		while ((*p == ' ') || (*p == '\t')) p++;
		if (strcasecmp(buf,"localpolicy") == 0) {
			strcpy(localpolicy,p);
		} else if (strcasecmp(buf,"usetrusted") == 0) {
			if ((strcasecmp(p,"yes") == 0) ||
			    (strcasecmp(p,"on") == 0)) {
				cfg->usetrusted=1;
			} else if ((strcasecmp(p,"no") == 0) ||
				   (strcasecmp(p,"off") == 0)) {
				cfg->usetrusted=0;
			} else {
				ERRLOG((LOG_ERR,"%s(%d): bad boolean \"%s\"",
					fbuf,count,p));
			}
		} else if (strcasecmp(buf,"addspfheader") == 0) {
			if ((strcasecmp(p,"yes") == 0) ||
			    (strcasecmp(p,"on") == 0)) {
				cfg->addspfheader=1;
			} else if ((strcasecmp(p,"no") == 0) ||
				   (strcasecmp(p,"off") == 0)) {
				cfg->addspfheader=0;
			} else {
				ERRLOG((LOG_ERR,"%s(%d): bad boolean \"%s\"",
					fbuf,count,p));
			}
		} else if (strcasecmp(buf,"threshold") == 0) {
			for (i=0;thresholds[i].txt;i++) {
				if (strcasecmp(p,thresholds[i].txt) == 0) {
					cfg->threshold=thresholds[i].num;
					break;
				}
			}
			if (thresholds[i].txt == NULL) {
				ERRLOG((LOG_ERR,"%s(%d): bad value \"%s\"",
					fbuf,count,p));
			}
		} else if (strcasecmp(buf,"whitelist") == 0) {
			if (parse_whitelist(cfg->whitelist,p))
				ERRLOG((LOG_ERR,"%s(%d): bad whitelist \"%s\"",
					fbuf,count,p));
		} else {
			ERRLOG((LOG_ERR,"%s(%d): bad verb \"%s\"",
				fbuf,count,buf));
		}
	} else {
		ERRLOG((LOG_ERR,"cannot open config file %s: %m",fbuf));
	}

	cfg->global=spf_newglobal(localpolicy[0]?localpolicy:NULL,
							cfg->usetrusted);
	return cfg;
}

void
spf_cleanconfig(cfg_t *cfg)
{
	if (cfg == NULL) return;
	spf_freeglobal(cfg->global);
	if (cfg->whitelist) free(cfg->whitelist);
	free(cfg);
}
