#ifndef LINT
static char *rcsid="$Id: libspf_iface.c 380 2005-06-04 11:55:01Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_SYS_UTSNAME_H
# include <sys/utsname.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>   /* inet_ functions / structs */
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>   /* inet_ functions / structs */
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h> /* in_addr struct */
#endif

#include <spf.h>

#include "report.h"
#include "libspf_any.h"

#define min(x,y) ((x<y)?x:y)

typedef struct _spf1global {
	char *localname;
	char *localpolicy;
	int usetrusted;
} spf1global_t;

typedef struct _spf1state {
	peer_info_t *pinfo;
	char *comment;
	char *header;
} spf1state_t;

spf_global_t
spf_newglobal(char *localpolicy,int usetrusted)
{
	spf1global_t *global;
	char localname[128];
#ifdef HAVE_SYS_UTSNAME_H
	struct utsname ubuf;
#endif

	if ((global=(spf1global_t*)malloc(sizeof(spf1global_t))) == NULL) {
		ERRLOG((LOG_ERR,"spf: nomem for spf_global"));
		return NULL;
	}
	memset(global,0,sizeof(spf1global_t));
	if (localpolicy) {
		global->localpolicy=(char*)malloc(strlen(localpolicy)+1);
		if (global->localpolicy)
			strcpy(global->localpolicy,localpolicy);
		else
			ERRLOG((LOG_ERR,"spf: nomem for localpolicy"));
	}
#ifdef HAVE_SYS_UTSNAME_H
	if (uname(&ubuf)) {
		ERRLOG((LOG_ERR,"spf: error gethostname: %m"));
		strcpy(localname,"local.name.not.set");
	} else {
		int len=min(strlen(ubuf.nodename),sizeof(localname)-1);
		strncpy(localname,ubuf.nodename,len);
		localname[len]='\0';
	}
#elif HAVE_GETHOSTNAME
	if (gethostname(localname,sizeof(localname))) {
		ERRLOG((LOG_ERR,"spf: error gethostname: %m"));
		strcpy(localname,"local.name.not.set");
	}
else
	strcpy(localname,"local.name.not.set");
#endif
	global->localname=(char*)malloc(strlen(localname)+1);
	if (global->localname)
		strcpy(global->localname,localname);
	else
		ERRLOG((LOG_ERR,"spf: nomem for localname"));
	global->usetrusted=usetrusted;
	return (spf_global_t)global;
}

void
spf_freeglobal(spf_global_t priv)
{
	spf1global_t *global=(spf1global_t*)priv;

	if (global == NULL) return;
	if (global->localname) free(global->localname);
	if (global->localpolicy) free(global->localpolicy);
	free(global);
}

spf_state_t
spf_newstate(spf_global_t gpriv)
{
	spf1global_t *global=(spf1global_t*)gpriv;
	spf1state_t *state;

	if ((state=(spf1state_t*)malloc(sizeof(spf1state_t))) == NULL) {
		ERRLOG((LOG_ERR,"spf: nomem for spf_state"));
		return NULL;
	}
	memset(state,0,sizeof(spf1state_t));
	return (spf_state_t)state;
}

void
spf_freestate(spf_state_t priv)
{
	spf1state_t *state=(spf1state_t *)priv;

	if (state == NULL) return;
	if (state->pinfo) {
		DPRINT(("spf1 free pinfo: %p\n",state->pinfo));
		SPF_close(state->pinfo);
	}
	if (state->comment) {
		DPRINT(("spf1 free comment: %p\n",state->comment));
		free(state->comment);
	}
	if (state->header) {
		DPRINT(("spf1 free header: %p\n",state->header));
		free(state->header);
	}
	DPRINT(("spf1 free state: %p\n",state));
	free(state);
}

int
spf_peerip(spf_global_t gpriv,spf_state_t priv,char *ipstr,int isv6)
{
	spf1global_t *global=(spf1global_t*)gpriv;
	spf1state_t *state=(spf1state_t *)priv;

	if ((state->pinfo=SPF_init(global->localname,ipstr,SPF_EXPLAIN,
			NULL,NULL,global->usetrusted,0)) == NULL) {
		ERRLOG((LOG_ERR,"spf: error SPF_init"));
		return -1;
	}
	return 0;
}

int
spf_helo(spf_global_t gpriv,spf_state_t priv,char *helostr)
{
	spf1global_t *global=(spf1global_t*)gpriv;
	spf1state_t *state=(spf1state_t *)priv;

	SPF_smtp_helo(state->pinfo,helostr);
	return 0;
}

int
spf_from(spf_global_t gpriv,spf_state_t priv,char *addrstr)
{
	spf1global_t *global=(spf1global_t*)gpriv;
	spf1state_t *state=(spf1state_t *)priv;
	char *p;

	DPRINT(("calling SPF_smtp_from(...,\"%s\")\n",addrstr));
	SPF_smtp_from(state->pinfo,addrstr);
	return 0;
}

int
spf_result(spf_global_t gpriv,spf_state_t priv,
		char **level,char **com,char **hdr)
{
	spf1global_t *global=(spf1global_t*)gpriv;
	spf1state_t *state=(spf1state_t *)priv;

	(*level)=NULL;

	if ((state->pinfo->RES=SPF_policy_main(state->pinfo)) == SPF_NONE)
		SPF_parse_policy(state->pinfo,global->localpolicy);

	DPRINT(("spf1 result %s: %s\n",state->pinfo->rs,state->pinfo->error));
	DPRINT(("spf1 exp str: %s\n",state->pinfo->explain));
	state->comment=SPF_get_explain(state->pinfo);
	DPRINT(("spf1 smtp msg: %s\n",state->comment?state->comment:"<none>"));
	state->header=SPF_build_header(state->pinfo);
	DPRINT(("spf1 header: %s\n",state->header?state->header:"<none>"));
	(*level)=state->pinfo->rs;
	(*com)=state->comment;
	(*hdr)=state->header;
	
	return 0;
}

