#ifndef LINT
static char *rcsid="$Id: libspf2_iface.c 394 2005-06-06 09:07:24Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>   /* inet_ functions / structs */
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>   /* inet_ functions / structs */
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h> /* in_addr struct */
#endif

#include <spf2/spf.h>

#include "report.h"
#include "libspf_any.h"

typedef struct _spf2global {
	SPF_server_t *spf_server;
} spf2global_t;

typedef struct _spf2state {
	SPF_request_t *spf_request;
	SPF_response_t *spf_response;
} spf2state_t;

spf_global_t
spf_newglobal(char *localpolicy,int usetrusted)
{
	spf2global_t *global;
	SPF_response_t *spf_response;

	if ((global=(spf2global_t*)malloc(sizeof(spf2global_t))) == NULL) {
		ERRLOG((LOG_ERR,"spf: nomem for spf_global"));
		return NULL;
	}
	memset(global,0,sizeof(spf2global_t));
	if ((global->spf_server=SPF_server_new(SPF_DNS_CACHE,0)) == NULL) {
		ERRLOG((LOG_ERR,"spf: error SPF_server_new"));
		return NULL;
	}
	if (localpolicy) {
		if (SPF_server_set_localpolicy(global->spf_server,
				localpolicy,usetrusted,&spf_response)) {
			ERRLOG((LOG_ERR,"spf: error set_localpolicy"));
			if (spf_response) SPF_response_free(spf_response);
		}
	}
	return (spf_global_t)global;
}

void
spf_freeglobal(spf_global_t priv)
{
	spf2global_t *global=(spf2global_t*)priv;

	if (global == NULL) return;
	if (global->spf_server) SPF_server_free(global->spf_server);
	free(global);
}

spf_state_t
spf_newstate(spf_global_t gpriv)
{
	spf2global_t *global=(spf2global_t*)gpriv;
	spf2state_t *state;

	if ((state=(spf2state_t*)malloc(sizeof(spf2state_t))) == NULL) {
		ERRLOG((LOG_ERR,"spf: nomem for spf_state"));
		return NULL;
	}
	memset(state,0,sizeof(spf2state_t));
	if ((state->spf_request=SPF_request_new(global->spf_server)) == NULL) {
		ERRLOG((LOG_ERR,"spf: error SPF_request_new"));
		return NULL;
	}
	return (spf_state_t)state;
}

void
spf_freestate(spf_state_t priv)
{
	spf2state_t *state=(spf2state_t *)priv;

	if (state == NULL) return;
	if (state->spf_response) SPF_response_free(state->spf_response);
	if (state->spf_request) SPF_request_free(state->spf_request);
	free(state);
}

int
spf_peerip(spf_global_t gpriv,spf_state_t priv,char *ipstr,int isv6)
{
	spf2global_t *global=(spf2global_t*)gpriv;
	spf2state_t *state=(spf2state_t *)priv;
	int rc=0;

#ifdef AF_INET6
	if (isv6)
		rc=SPF_request_set_ipv6_str(state->spf_request,ipstr);
	else
#endif /* AF_INET6 */
		rc=SPF_request_set_ipv4_str(state->spf_request,ipstr);
	if (rc) {
		ERRLOG((LOG_ERR,"spf: error SPF_request_set_ipvX_str(\"%s\")",
					ipstr));
		return -1;
	}
	return 0;
}

int
spf_helo(spf_global_t gpriv,spf_state_t priv,char *helostr)
{
	spf2global_t *global=(spf2global_t*)gpriv;
	spf2state_t *state=(spf2state_t *)priv;

	if (SPF_request_set_helo_dom(state->spf_request,helostr)) {
		ERRLOG((LOG_ERR,"spf: error SPF_set_helo_dom(\"%s\")",
					helostr));
		return -1;
	} else return 0;
}

int
spf_from(spf_global_t gpriv,spf_state_t priv,char *addrstr)
{
	spf2global_t *global=(spf2global_t*)gpriv;
	spf2state_t *state=(spf2state_t *)priv;

	if (SPF_request_set_env_from(state->spf_request,addrstr)) {
		ERRLOG((LOG_ERR,"spf: error SPF_request_set_env_from(\"%s\")",
					addrstr));
		return -1;
	} else return 0;
}

int
spf_result(spf_global_t gpriv,spf_state_t priv,
		char **level,char **com,char **hdr)
{
	spf2global_t *global=(spf2global_t*)gpriv;
	spf2state_t *state=(spf2state_t *)priv;
	int i;
	int errcode,result;
	char *comment,*header;

	(*level)=NULL;
	(*com)=NULL;
	(*hdr)=NULL;
	SPF_request_query_mailfrom(state->spf_request,&state->spf_response);
	if ((errcode=SPF_response_errcode(state->spf_response))) {
		DPRINT(("spf error %d: %s\n",errcode,SPF_strerror(errcode)));
		ERRLOG((LOG_ERR,"spf: error %d SPF_request_set_env_from: %s",
			errcode,SPF_strerror(errcode)));
		return -1;
	}
	if (verbose) for (i=0;i<SPF_response_messages(state->spf_response);i++) {
		SPF_error_t *spf_error;
		spf_error=SPF_response_message(state->spf_response,i);
		DPRINT(("  %d %s: %s%s\n",i,
			SPF_error_errorp(spf_error)?"Error":"Warning",
			SPF_error_errorp(spf_error)?"[UN]":"",
			SPF_error_message(spf_error)));
	}
	result=SPF_response_result(state->spf_response);
	DPRINT(("spf2 result %d: %s\n",result,SPF_strresult(result)));
	comment=SPF_response_get_smtp_comment(state->spf_response);
/*
	for reason beyond my comprehension, libspf2 produces this string:
	Please%see%http://.. with spurious percent signs.  We'll remove them.
*/
	if (comment &&
	    strncmp(comment,"Please%see%",strlen("Please%see%")) == 0) {
		*(strchr(comment,'%'))=' ';
		*(strchr(comment,'%'))=' ';
	}
/*
	end hack
*/
	DPRINT(("spf2 smtp msg: %s\n",comment?comment:"<none>"));
	header=SPF_response_get_received_spf(state->spf_response);
	DPRINT(("spf2 header: %s\n",header?header:"<none>"));
	(*level)=SPF_strresult(result);
	(*com)=comment;
	(*hdr)=header;
	
	return 0;
}

