#ifndef LINT
static char *rcsid="$Id: dispatch_ct.c 372 2005-05-31 14:09:18Z crosser $";
#endif

/*
	$Log: dispatch_ct.c,v $
	Revision 1.10  2003/09/11 08:01:25  crosser
	unnecessary stat.h
	
	Revision 1.9  2003/09/11 05:30:38  crosser
	cosmetics and typos
	
	Revision 1.8  2003/09/10 18:25:28  crosser
	off by one - do match to content subtype
	
	Revision 1.7  2003/09/10 17:55:21  crosser
	fix boundary check
	
	Revision 1.6  2003/09/10 16:29:27  crosser
	segfault on empty mattr
	
	Revision 1.5  2003/09/10 09:54:05  crosser
	wrong assignment removed
	
	Revision 1.4  2003/09/09 22:15:50  crosser
	more doc; typo in plugin
	
	Revision 1.3  2003/09/09 20:02:10  crosser
	complete dispatcher; change "body" stage to "content" for consistency
	
	Revision 1.2  2003/09/09 17:40:29  crosser
	wip on dispatcher
	
	Revision 1.1  2003/09/09 17:02:01  crosser
	dispatch_ct introduced to invoke appropriate content processors
	depending on content-type of the body(part)
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
dispatch_ct_setup(void **cfgp)
{
	DPRINT(("dispatch_ct_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
dispatch_ct_term(void **cfgp)
{
	DPRINT(("dispatch_ct_term called\n"));
}

static struct _typs {
	char *str;
	enum _typ {c_text, c_image, c_application, c_misc} typ;
} typs[] = {
	{"text",	c_text},
	{"image",	c_image},
	{"application",	c_application},
	{NULL,		c_misc}
};
#define NTYPS (sizeof(typs)/sizeof(struct _typs))

static struct _t_typs {
	char *str;
	enum _t_typ {t_plain, t_html, t_misc} typ;
} t_typs[] = {
	{"plain",	t_plain},
	{"html",	t_html},
	{NULL,		t_misc}
};
#define NTTYPS (sizeof(t_typs)/sizeof(struct _t_typs))
/* follows a compile-time number that can be userd as array size */
/* hope that this is not a GCC'ism, and will work with other CCs... */
#define MAXPAT ((NTYPS>NTTYPS)?NTYPS:NTTYPS)

static int
dispatch_ct_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int i,rc;
	enum _typ typ;
	enum _t_typ t_typ=t_plain;
	char *p;
	char *q[MAXPAT];
	mattr_t *atr=(mattr_t *)data.atr;
	slab_t ctype=atr->content_type;

	DPRINT(("dispatch_ct_scan called size=%d\n",slab_size(data)));
	DPRINT(("content-type \"%.*s\"\n",
		slab_size(ctype),ctype.beg));
	DPRINT(("name         \"%.*s\"\n",
		slab_size(atr->name),atr->name.beg));
	DPRINT(("charset      \"%.*s\"\n",
		slab_size(atr->charset),atr->charset.beg));

	for (i=0;typs[i].str;i++) q[i]=typs[i].str;
	i=0;
	for (p=ctype.beg;p<ctype.end;p++) {
		for (i=0;typs[i].str;i++) {
			if (toupper(*q[i]) == toupper(*p)) q[i]++;
			else q[i]=typs[i].str;
			if (*(q[i]) == '\0') goto found;
		}
	}
	found:
	typ=i;
#if 0
	DPRINT(("content type typ=%d\n",typ));
#endif
	if ((p < ctype.end) && (*p == '/')) p++;

	if (typ == c_text) {
		for (i=0;t_typs[i].str;i++) q[i]=t_typs[i].str;
		i=0;
		for (;p<ctype.end;p++) {
			for (i=0;t_typs[i].str;i++) {
				if (toupper(*q[i]) == toupper(*p)) q[i]++;
				else q[i]=t_typs[i].str;
				if (*(q[i]) == '\0') goto t_found;
			}
		}
		t_found:
		t_typ=i;
	}

	DPRINT(("content type typ=%d t_typ=%d\n",typ,t_typ));

	switch (typ) {
	case c_text:
		rc=scandata("content_text",depth,data,vp);
		if (rc != ZMSCAN_CONTINUE) return rc;
		switch (t_typ) {
		case t_plain:
			return scandata("content_text_plain",depth,data,vp);
			break;
		case t_html:
			return scandata("content_text_html",depth,data,vp);
			break;
		case t_misc:
			return scandata("content_text_misc",depth,data,vp);
			break;
		default:
			ERRLOG((LOG_ERR,"dispatch_ct: impossibe subtype %d",
								t_typ));
			return ZMSCAN_CONTINUE;
			break;
		}
		break;
	case c_image:
		return scandata("content_image",depth,data,vp);
		break;
	case c_application:
		return scandata("content_application",depth,data,vp);
		break;
	case c_misc:
		return scandata("content_misc",depth,data,vp);
		break;
	default:
		ERRLOG((LOG_ERR,"dispatch_ct: impossibe type %d",typ));
		return ZMSCAN_CONTINUE;
	}
}

ZMS_MODULE("content","dispatch_ct",dispatch_ct_setup,
				dispatch_ct_term,dispatch_ct_scan);
