#ifndef LINT
static char *rcsid="$Id: dispatch_body.c 397 2005-06-29 10:16:37Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
dispatchbody_setup(void **cfgp)
{
	DPRINT(("dispatchbody_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
dispatchbody_term(void **cfgp)
{
	DPRINT(("dispatchbody_term called\n"));
}

static int
dispatchbody_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	mattr_t *matr=(mattr_t*)data.atr;
	slab_t edata;
	mattr_t eattr;

	DPRINT(("dispatchbody_scan called size=%d\n",slab_size(data)));

	switch (matr->btype) {
	case t_single:
		switch (matr->benc) {
		case e_plain:
			return scandata("content",depth,data,vp);
			break;
		case e_qp:
			return scandata("body_qp",depth,data,vp);
			break;
		case e_base64:
			return scandata("body_base64",depth,data,vp);
			break;
		case e_uue:
			return scandata("body_uue",depth,data,vp);
			break;
		default:
			ERRLOG((LOG_ERR,"impossible message encoding"));
			return ZMSCAN_CONTINUE;
		}
		break;
	case t_message:
		initattr(&eattr,(mattr_t*)(data.atr));
		memset(&edata,0,sizeof(edata));
		edata.beg=data.beg;
		edata.end=data.end;
		edata.atr=(void*)&eattr;
		return scandata("rfc822",depth+1,edata,vp);
		break;
	case t_multipart:
		return scandata("multibody",depth,data,vp);
		break;
	default:
		ERRLOG((LOG_ERR,"impossible message type"));
		return ZMSCAN_CONTINUE;
	}
}

ZMS_MODULE("body","dispatchbody",dispatchbody_setup,
				dispatchbody_term,dispatchbody_scan);
