#ifndef LINT
static char *rcsid="$Id: decode_b64.c 266 2005-04-17 13:37:59Z crosser $";
#endif

/*
	$Log: decode_b64.c,v $
	Revision 1.5  2003/09/11 09:04:51  crosser
	cosmetics
	
	Revision 1.4  2003/09/09 20:02:10  crosser
	complete dispatcher; change "body" stage to "content" for consistency
	
	Revision 1.3  2003/09/08 12:55:55  crosser
	make static and dynamic plugins syntactically identical
	
	Revision 1.2  2003/09/06 19:21:53  crosser
	implemented base64 decoding
	
	Revision 1.1  2003/09/05 17:43:27  crosser
	placeholders for body decoders
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
decode_b64_setup(void **cfgp)
{
	DPRINT(("decode_b64_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
decode_b64_term(void **cfgp)
{
	DPRINT(("decode_b64_term called\n"));
}

static int
decode_b64_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	slab_t edata;
	char *dec_data;
	char *p,*q;
	char c,c1,c2,c3,c4;
	enum {b1,b2,b3,b4} bstatus;

	DPRINT(("decode_b64_scan called size=%d\n",slab_size(data)));

	dec_data=(char *)malloc(slab_size(data)*3/4);
	if (dec_data == NULL) {
		ERRLOG((LOG_ERR,"decode_b64 could not alloc %d bytes",
							slab_size(data)));
		return ZMSCAN_CONTINUE;
	}

	p=data.beg;
	q=dec_data;
	bstatus=b1;
	for (c=*p++;p<data.end;c=*p++) {
#if 0
		DPRINT(("in byte %c ->",c));
#endif
		if ((c >= 'A') && (c <= 'Z')) c-='A';
		else if ((c >= 'a') && (c <= 'z')) c-=('a'-26);
		else if ((c >= '0') && (c <= '9')) c-=('0'-52);
		else if (c == '+') c=62;
		else if (c == '/') c=63;
		else if (c == '=') c=64; /* padding */
		else continue; /* junk such as newlines etc. */
#if 0
		DPRINT(("%d\n",c));
#endif
		switch (bstatus) {
		case b1:
			if (c != 64) {
				c1=c;
				bstatus=b2;
			}
			break;
		case b2:
			if (c != 64) {
				c2=c;
				*q++=(c1<<2)|((c2&0x30)>>4);
				bstatus=b3;
			}
			break;
		case b3:
			c3=c;
			if (c != 64) {
				*q++=((c2&0x0f)<<4)|((c3&0x3c)>>2);
			}
			bstatus=b4;
			break;
		case b4:
			c4=c;
			if ((c != 64) && (c3 != 64)) {
				*q++=((c3&0x03)<<6)|c4;
			}
			bstatus=b1;
			break;
		}
	}

	edata.beg=dec_data;
	edata.end=q;
	edata.atr=data.atr;

	DPRINT(("decode_b64_scan decoded size=%d\n",slab_size(edata)));

	rc=scandata("content",depth,edata,vp);
	free(dec_data);
	return rc;
}

ZMS_MODULE("body_base64","decode_b64",decode_b64_setup,decode_b64_term,decode_b64_scan);
