#ifndef LINT
static char *rcsid="$Id: breakzmsg.c 279 2005-05-10 14:44:39Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakzmsg_setup(void **cfgp)
{
	DPRINT(("breakzmsg_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakzmsg_term(void **cfgp)
{
	DPRINT(("breakzmsg_term called\n"));
}

static int
breakzmsg_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	char *p,*q,*ls;
	slab_t edata;
	static char *pat="\nenv-end\n";

	DPRINT(("breakzmsg_scan called size=%d\n",slab_size(data)));
	memset(&edata,0,sizeof(edata));
	edata.atr=data.atr;
	ls=data.beg;
	q=pat;
	for (p=data.beg;p<data.end;p++) {
		if (*p == '\r') continue;
		if (*q == '\0') break;
		if ((*p == '\n') && (q == pat)) {
			DPRINT(("env line at offset %d(%d): \"%.*s\"\n",
				ls-data.beg,p-ls,p-ls,ls));
			edata.beg=ls;
			edata.end=p;
			rc=scandata("zenvhdr",depth,edata,vp);
			if (rc != ZMSCAN_CONTINUE) return rc;
			ls=p+1;
		}
		if (*p == *q) {
			q++;
		} else if (*p == '\n') {
			q=pat+1;
		} else q=pat;
	}
	if (*q == '\0') {
		edata.beg=p;
		edata.end=data.end;
		DPRINT(("start rfc822 at off %d: \"%.20s\"\n",
					edata.beg-data.beg,edata.beg));
		return scandata("rfc822",depth,edata,vp);
	} else {
		ERRLOG((LOG_WARNING,"\"env-end\" not found in a message"));
		/* try the thing as RFC-822 message */
		return scandata("rfc822",depth,data,vp);
	}
}

ZMS_MODULE("zmsg","breakzmsg",breakzmsg_setup,breakzmsg_term,breakzmsg_scan);
