#ifndef LINT
static char *rcsid="$Id: breakzhdr.c 397 2005-06-29 10:16:37Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakzhdr_setup(void **cfgp)
{
	DPRINT(("breakzhdr_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakzhdr_term(void **cfgp)
{
	DPRINT(("breakzhdr_term called\n"));
}

typedef enum { h_rcvd, h_from, h_rcpt, h_other } bhdr_t;
static struct _hdrs {
	char *str;
	bhdr_t idx;
} hdrs[] = {
	{"comment ",	h_rcvd}, /* ugly... it has better syntax than rcvd */
	{"from ",	h_from},
	{"to ",		h_rcpt},
	{NULL,		h_other}
};
#define MAXPAT (sizeof(hdrs)/sizeof(struct _hdrs))

static int
breakrcvd(int depth,slab_t data,varpool_t vp)
{
	int rc;
	int blanks=0;
	char *p,*q;
	slab_t edata;

	DPRINT(("breakrcvd called \"%.*s\"\n",slab_size(data),data.beg));
	memset(&edata,0,sizeof(edata));
	edata.atr=data.atr;

	for (p=data.beg;p<data.end;p++) {
		if (*p == ' ') blanks++;
		if (blanks >= 2) break;
	}
	
	edata.beg=data.beg;
	edata.end=p;
	if (slab_size(edata) <= 0) return ZMSCAN_CONTINUE;
	DPRINT(("peerdata: \"%.*s\"\n",slab_size(edata),edata.beg));
	rc=scandata("peerdata",depth,edata,vp);
	if (rc != ZMSCAN_CONTINUE) return rc;

	p++;
	if ((p < data.end) && (*p == '"')) p++;
	while ((p < data.end) && (*p != ' ')) p++;
	p++;
	for (q=p;q<data.end;q++) {
		if (*q == '"') break;
	}
	if (*q != '"') return ZMSCAN_CONTINUE;

	edata.beg=p;
	edata.end=q;
	if (slab_size(edata) <= 0) return ZMSCAN_CONTINUE;
	DPRINT(("helo: \"%.*s\"\n",slab_size(edata),edata.beg));
	rc=scandata("helo",depth,edata,vp);
	if (rc != ZMSCAN_CONTINUE) return rc;
	return ZMSCAN_CONTINUE;
}

static int
cutaddr(char *which,int depth,slab_t data,varpool_t vp)
{
	slab_t edata;

	memset(&edata,0,sizeof(edata));
	edata.beg=data.beg;
	edata.end=data.end;
	edata.atr=data.atr;
	if ((*edata.beg == '<') && (*(edata.end-1) == '>')) {
		edata.beg++;
		edata.end--;
	}
	
	DPRINT(("cutaddr yeld %s \"%.*s\"\n",which,slab_size(edata),edata.beg));
	return scandata(which,depth,edata,vp);
}

static int
breakzhdr_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int i,miss;
	bhdr_t t=h_other;
	char *p,*q[MAXPAT];
	slab_t edata;

	DPRINT(("breakzhdr_scan called size=%d\n",slab_size(data)));

	memset(&edata,0,sizeof(edata));

	for (i=0;hdrs[i].str;i++) q[i]=hdrs[i].str;
	for (p=data.beg;p<data.end;p++) {
		miss=1;
		for (i=0;hdrs[i].str;i++) {
			if (*(q[i]) == '\0') goto found;
			if (toupper(*q[i]) == toupper(*p)) {
				q[i]++;
				miss=0;
			} else q[i]=hdrs[i].str;
		}
		if (miss) goto found;
	}
	found:
	t=hdrs[i].idx;

	while ((p < data.end) && ((*p == ' ') || (*p == '\t') ||
				  (*p == '\r') || (*p == '\n'))) p++;

	edata.beg=p;
	edata.end=data.end;
	edata.atr=data.atr;

	switch(t) {
	case h_rcvd:
		return breakrcvd(depth,edata,vp);
	case h_from:
		return cutaddr("envfrom",depth,edata,vp);
	case h_rcpt:
		return cutaddr("envrcpt",depth,edata,vp);
	}
	return ZMSCAN_CONTINUE;
}

ZMS_MODULE("zenvhdr","breakzhdr",breakzhdr_setup,
				breakzhdr_term,breakzhdr_scan);
