#ifndef LINT
static char *rcsid="$Id: breakrfc822.c 290 2005-05-12 12:50:25Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakrfc822_setup(void **cfgp)
{
	DPRINT(("breakrfc822_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakrfc822_term(void **cfgp)
{
	DPRINT(("breakrfc822_term called\n"));
}

static int
breakrfc822_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	char *p,*hs,*bs;
	int nlseen;
	mattr_t *matr=data.atr;
	slab_t edata;

	DPRINT(("breakrfc822_scan called size=%d\n",slab_size(data)));

	memset(&edata,0,sizeof(edata));
	edata.atr=(void *)matr;

	hs=data.beg;
	nlseen=0;
	for (p=data.beg;p<data.end;p++) {
		if (*p == '\r') continue;
		if (nlseen) { /* first character after newline */
			if ((*p != ' ') && (*p != '\t')) {
				DPRINT(("header at offset %d\n",
							hs-data.beg));
				edata.beg=hs;
				edata.end=p;
				rc=scandata("rfc822hdr",depth,edata,vp);
				if (rc != ZMSCAN_CONTINUE) return rc;
				hs=p;
			}
			nlseen=0; /* should we tolerate sep line with space? */
			if (*p == '\n') break; /* second newline in a row */
		}
		if (*p == '\n') nlseen=1;
	}

	/* matr should have been filled as a side effect of header scanning */
	DPRINT(("breakrfc822_scan atr btype=%d\n",matr->btype));
	DPRINT(("breakrfc822_scan atr benc=%d\n",matr->benc));
	DPRINT(("breakrfc822_scan atr content_type=\"%.*s\"\n",
			slab_size(matr->content_type),matr->content_type.beg));
	DPRINT(("breakrfc822_scan atr boundary=\"%.*s\"\n",
			slab_size(matr->boundary),matr->boundary.beg));
	DPRINT(("breakrfc822_scan atr name=\"%.*s\"\n",
			slab_size(matr->name),matr->name.beg));
	DPRINT(("breakrfc822_scan atr charset=\"%.*s\"\n",
			slab_size(matr->charset), matr->charset.beg));
	if ((matr->btype == t_multipart) && (slab_size(matr->boundary) == 0)) {
		/* I've seen DSNs from some broken MTA that generated
		   mulipart/mixed entities without boundary! Being
		   obvously broken, we have a choice of treating such
		   things as either text/plain or message/rfc822.
		   In my case, body of the entity was in fact an
		   enclosed message.  So, let's try this: */
		matr->btype=t_message;
	}

	if (p < data.end) p++;
	DPRINT(("body starts at %d: \"%.20s\"\n",p-data.beg,p));
	edata.beg=p;
	edata.end=data.end;
	return scandata("body",depth,edata,vp);
}

ZMS_MODULE("rfc822","breakrfc822",breakrfc822_setup,
				breakrfc822_term,breakrfc822_scan);
