#ifndef LINT
static char *rcsid="$Id: breakhdr_ct.c 279 2005-05-10 14:44:39Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakhdr_ct_setup(void **cfgp)
{
	DPRINT(("breakhdr_ct_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakhdr_ct_term(void **cfgp)
{
	DPRINT(("breakhdr_ct_term called\n"));
}

static struct _typs {
	char *str;
	btype_t idx;
} typs[] = {
	{"multipart",	t_multipart},
	{"message",	t_message},
	{NULL,		t_single}
};
#define TSIZE (sizeof(typs)/sizeof(struct _typs))

static void parse_ct(char *s,char *e,mattr_t *matr)
{
	int i,miss;
	char *p,*q[TSIZE];

	DPRINT(("parse_ct: \"%.*s\"\n",e-s,s));

	for (i=0;typs[i].str;i++) q[i]=typs[i].str;
	for (p=s;p<e;p++) {
		miss=1;
		for (i=0;typs[i].str;i++) {
			if (*(q[i]) == '\0') goto found;
			if (toupper(*q[i]) == toupper(*p)) {
				q[i]++;
				miss=0;
			} else q[i]=typs[i].str;
		}
		if (miss) goto found;
	}
	found:
	DPRINT(("btype is %d (%s)\n",typs[i].idx,typs[i].str));
	matr->btype=typs[i].idx;
	matr->content_type.beg=s;
	matr->content_type.end=e;
}

typedef enum {a_bndry, a_name, a_cset, a_other } batr_t;
static struct _atrs {
	char *str;
	batr_t idx;
} atrs[] = {
	{"boundary",	a_bndry},
	{"name",	a_name},
	{"charset",	a_cset},
	{NULL,		a_other}
};
#define ASIZE (sizeof(atrs)/sizeof(struct _atrs))

static void parse_atr(char *s,char *e,mattr_t *matr)
{
	int i;
	batr_t a;
	char *p,*r,*t,*q[ASIZE];

	DPRINT(("parse_atr: \"%.*s\"\n",e-s,s));

	for (r=s;r<e;r++) {
		if ((*r == '=') || (*r == '"')) break;
	}
	if ((r >= e) || (*r != '=')) {
		DPRINT(("cannot parse attr name in \"%.*s\"\n",e-s,s));
		return;
	}
	t=r;
	while ((t > s) && ((*(t-1) == ' ') || (*(t-1) == '\t') ||
			   (*(t-1) == '\r') || (*(t-1) == '\n'))) t--;
	r++;
	while ((r < e) && ((*r == ' ') || (*r == '\t') ||
			   (*r == '\r') || (*r == '\n'))) r++;

	for (i=0;atrs[i].str;i++) q[i]=atrs[i].str;
	for (p=s;p<t;p++) {
		for (i=0;atrs[i].str;i++) {
			if (q[i] == NULL) continue;
			if (*q[i] == '\0') continue;
			if (toupper(*q[i]) == toupper(*p)) q[i]++;
			else q[i]=NULL;
		}
	}
	for (i=0;atrs[i].str;i++) {
		if (q[i] == NULL) continue;
		if (*q[i] == '\0') break;
	}
	a=atrs[i].idx;
	if ((r < e) && (*r == '"')) r++;
	if ((e > r) && (*(e-1) == '"')) e--;
	DPRINT(("batr is %d (%s) value \"%.*s\"\n",
			atrs[i].idx,atrs[i].str,e-r,r));
	switch (a) {
	case a_bndry:
		matr->boundary.beg=r;
		matr->boundary.end=e;
		break;
	case a_name:
		matr->name.beg=r;
		matr->name.end=e;
		break;
	case a_cset:
		matr->charset.beg=r;
		matr->charset.end=e;
		break;
	}
}

static void parse_ct_or_atr(char *s,char *e,mattr_t *matr,int firstcall)
{
	while ((s < e) && ((*s == ' ') || (*s == '\t') ||
			   (*s == '\r') || (*s == '\n'))) s++;
	while ((e > s) && ((*(e-1) == ' ') || (*(e-1) == '\t') ||
			   (*(e-1) == '\r') || (*(e-1) == '\n'))) e--;

	if (s >= e) return;

	if (firstcall) parse_ct(s,e,matr);
	else parse_atr(s,e,matr);
}

static int
breakhdr_ct_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	char *p,*s;
	mattr_t *matr=data.atr;
	int inquotes,firstcall;
	enum {s_pass,} state;

	DPRINT(("breakhdr_ct_scan called size=%d\n",slab_size(data)));

	if (matr->usefirst && matr->type_set) {
		DPRINT(("breakhdr_ct_scan not first, ignored\n"));
		return ZMSCAN_CONTINUE;
	}
	matr->type_set=1;

	s=data.beg;
	inquotes=0;
	firstcall=1;
	for (p=data.beg;p<data.end;p++)
	if (inquotes) {
		if (*p == '"') inquotes=0;
	} else {
		if (*p == ';') {
			parse_ct_or_atr(s,p,matr,firstcall);
			firstcall=0;
			s=p+1;
		} else if (*p == '"') inquotes=1;
	}
	parse_ct_or_atr(s,p,matr,firstcall);

	return ZMSCAN_CONTINUE;
}

ZMS_MODULE("rfc822hdr_ct","breakhdr_ct",breakhdr_ct_setup,
				breakhdr_ct_term,breakhdr_ct_scan);
