#ifndef LINT
static char *rcsid="$Id: breakhdr.c 319 2005-05-18 16:11:02Z crosser $";
#endif

/*
	$Log: breakhdr.c,v $
	Revision 1.4  2003/09/13 11:41:16  crosser
	make new header parsing actually work
	
	Revision 1.3  2003/09/12 22:54:52  crosser
	incomplete content-type parsing
	
	Revision 1.2  2003/09/12 15:22:41  crosser
	break parsing to separate modules (just placeholders for now)
	
	Revision 1.1  2003/09/12 14:18:34  crosser
	placeholders for header processors
	
*/
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakhdr_setup(void **cfgp)
{
	DPRINT(("breakhdr_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakhdr_term(void **cfgp)
{
	DPRINT(("breakhdr_term called\n"));
}

typedef enum { h_ct, h_cte, h_other } bhdr_t;
static struct _hdrs {
	char *str;
	bhdr_t idx;
} hdrs[] = {
	{"Content-Type:",		h_ct},
	{"Content-Transfer-Encoding:",	h_cte},
	{NULL,				h_other}
};
#define MAXPAT (sizeof(hdrs)/sizeof(struct _hdrs))

static int
breakhdr_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc,i,miss;
	bhdr_t t=h_other;
	char *p,*q[MAXPAT];
	slab_t edata;

	DPRINT(("breakhdr_scan called size=%d\n",slab_size(data)));
#if 0
	DPRINT(("breakhdr_scan called \"%.*s\"\n",slab_size(data),data.beg));
#endif

	memset(&edata,0,sizeof(edata));

	for (i=0;hdrs[i].str;i++) q[i]=hdrs[i].str;
	for (p=data.beg;p<data.end;p++) {
		miss=1;
		for (i=0;hdrs[i].str;i++) {
			if (*(q[i]) == '\0') goto found;
			if (toupper(*q[i]) == toupper(*p)) {
				q[i]++;
				miss=0;
			} else q[i]=hdrs[i].str;
		}
		if (miss) goto found;
	}
	found:
	t=hdrs[i].idx;

	while ((p < data.end) && ((*p == ' ') || (*p == '\t') ||
				  (*p == '\r') || (*p == '\n'))) p++;

	edata.beg=p;
	edata.end=data.end;
	edata.atr=data.atr;

	switch(t) {
	case h_ct:
		rc=scandata("rfc822hdr_ct",depth,edata,vp);
		if (rc != ZMSCAN_CONTINUE) return rc;
		break;
	case h_cte:
		rc=scandata("rfc822hdr_cte",depth,edata,vp);
		if (rc != ZMSCAN_CONTINUE) return rc;
		break;
	}
	return ZMSCAN_CONTINUE;
}

ZMS_MODULE("rfc822hdr","breakhdr",breakhdr_setup,
				breakhdr_term,breakhdr_scan);
