#ifndef LINT
static char *rcsid="$Id: breakbody.c 319 2005-05-18 16:11:02Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
# include <ctype.h>
#endif

#include "report.h"
#include "zmscanner.h"

static int
breakbody_setup(void **cfgp)
{
	DPRINT(("breakbody_setup called\n"));
	(*cfgp)=NULL;
	return 0;
}

static void
breakbody_term(void **cfgp)
{
	DPRINT(("breakbody_term called\n"));
}

static int
breakbody_scan(char *stage,int depth,slab_t data,varpool_t vp,void *priv)
{
	int rc;
	mattr_t eattr;
	slab_t edata;
	slab_t bndry;
	char *p,*bp,*sop,*eop;
	enum {
		waitnl,waitminus1,waitminus2,inboundary,
		endbound,waitnextnl,waitlastminus,trail
	     } state;

	DPRINT(("breakbody_scan called size=%d\n",slab_size(data)));
	if (data.atr == NULL) {
		ERRLOG((LOG_WARNING,"breakbody called but atr not supplied"));
		return ZMSCAN_CONTINUE;
	}
	bndry=((mattr_t*)data.atr)->boundary;
	if (slab_size(bndry) == 0) {
		ERRLOG((LOG_WARNING,"breakbody called with empty boundary"));
		saveqfile();
		return ZMSCAN_CONTINUE;
	}

	DPRINT(("boundary is \"%.*s\"\n",slab_size(bndry),bndry.beg));

	memset(&edata,0,sizeof(edata));
	sop=data.end;
	eop=data.beg;
	edata.atr=(void*)&eattr;
	state=waitnl;
	for (p=data.beg;p<data.end;p++) {
		if (*p == '\r') continue;
#if 0
		DPRINT(("switched from %d",state));
#endif
		switch (state) {
		case waitnl:
			if (*p == '\n') {
				eop=p;
				state=waitminus1;
			}
			break;
		case waitminus1:
			if (*p == '-') {
				state=waitminus2;
			}
			else if (*p == '\n') {
				eop=p;
			} else state=waitnl;
			break;
		case waitminus2:
			if (*p == '-') {
				state=inboundary;
				bp=bndry.beg;
			} else state=waitnl;
			break;
		case inboundary:
			if (bp >= bndry.end) {
				if (eop > sop) {
					edata.beg=sop;
					edata.end=eop;
					initattr(&eattr,(mattr_t*)(data.atr));
					rc=scandata("rfc822",depth+1,edata,vp);
					if (rc != ZMSCAN_CONTINUE) return rc;
					sop=data.end; /* no rescan on errors */
				}
				if (*p == '\n') {
					state=endbound;
				} else if (*p == '-') {
					state=waitlastminus;
				} else {
					/* actually this is the error */
					DPRINT(("\nbad char '%02x'\n\t",*p));
					state=waitnextnl;
				}
			}
			else if (*bp == *p) bp++;
			else state=waitnl;
			break;
		case endbound:
			sop=p;
			state=waitnl;
			break;
		case waitnextnl:
			/* this is a format error, actually... */
			if (*p == '\n') {
				state=endbound;
			}
			break;
		case waitlastminus:
			if (*p == '-') state=trail;
			else state=waitnl; /* try to find more data... */
			break;
		case trail:
			break; /* skip till the end */
		}
#if 0
		DPRINT((" to %d looking at \"%.20s\"\n",state,p));
#endif
	}
	if (state != trail) { /* process incomplete data */
		edata.beg=sop;
		edata.end=eop;
		initattr(&eattr,(mattr_t*)(data.atr));
		rc=scandata("rfc822",depth+1,edata,vp);
		if (rc != ZMSCAN_CONTINUE) return rc;
	}
	return ZMSCAN_CONTINUE;
}

ZMS_MODULE("multibody","breakbody",breakbody_setup,
				breakbody_term,breakbody_scan);
