#ifndef LINT
static char *rcsid="$Id: varpool.c 347 2005-05-20 17:53:31Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif

#include "lhash.h"
#include "report.h"
#include "zmscanner.h"

static unsigned long
vphash_hash(varobj_t *vo) {
	return lh_strhash(vo->name);
}

static int
vphash_cmp(varobj_t *vo1,varobj_t *vo2)
{
	return strcmp(vo1->name,vo2->name);
}

static void
vphash_destruct_vo(varobj_t *vo)
{
	DPRINT(("vp destroying \"%s\"\n",vo->name));
	(vo->destructor)(vo->object);
	free(vo);
}

static void
vphash_cleanup(varobj_t *vo,LHASH *lh)
{
	varobj_t *del;

	del=(varobj_t *)lh_delete(lh,vo);
	if (del) {
		vphash_destruct_vo(del);
	}
}

static IMPLEMENT_LHASH_HASH_FN(vphash_hash,varobj_t *);
static IMPLEMENT_LHASH_COMP_FN(vphash_cmp,varobj_t *);
static IMPLEMENT_LHASH_DOALL_ARG_FN(vphash_cleanup,varobj_t *,LHASH *);

varpool_t
vp_create_vp(void)
{
	LHASH *vp;

	vp=lh_new(LHASH_HASH_FN(vphash_hash),LHASH_COMP_FN(vphash_cmp));
	return (varpool_t)vp;
}

void
vp_destroy_vp(varpool_t vp) {
	LHASH *lh=(LHASH *)vp;

	lh->down_load=0; /* "second best solution" to not loose entries */
	lh_doall_arg(lh,LHASH_DOALL_ARG_FN(vphash_cleanup),(void *)lh);
	lh_free(lh);
}

int
vp_set(varpool_t vp,char *name,void *object,void (*destructor)(void *)) {
	LHASH *lh=(LHASH *)vp;
	varobj_t *new,*old;

	if (strlen(name) > (VP_MAXNAME-1)) {
		ERRLOG((LOG_ERR,"vp_set: too long name \"%s\"",name));
		(destructor)(object);
		return -1;
	}
	new=(varobj_t *)malloc(sizeof(varobj_t));
	if (new == NULL) {
		ERRLOG((LOG_ERR,"vp_set: cannot alloc varobj for \"%s\"",name));
		(destructor)(object);
		return -1;
	}
	memset(new,0,sizeof(varobj_t));
	strcpy(new->name,name);
	new->object=object;
	new->destructor=destructor;
	old=lh_insert(lh,(void *)new);
	if (old) {
		DPRINT(("vp_set replaced old var \"%s\"\n",name));
		vphash_destruct_vo(old);
		return 1;
	} else {
		DPRINT(("vp_set added new var \"%s\"\n",name));
		return 0;
	}
}

static void
vp_noop_destructor(void *object) {
	DPRINT(("vp_noop_destructor called\n"));
}

int
vp_set_int(varpool_t vp,char *name,int value) {
	return vp_set(vp,name,(void *)value,vp_noop_destructor);
}

static void
vp_str_destructor(void *object) {
	DPRINT(("vp_str_destructor called\n"));
	free(object);
}

int
vp_set_str(varpool_t vp,char *name,char *value) {
	char *copy;

	copy=(char *)malloc(strlen(value)+1);
	if (copy == NULL) {
		ERRLOG((LOG_ERR,"vp_set_str: cannot alloc space for %s=\"%s\"",
							name,value));
		return -1;
	}
	strcpy(copy,value);
	return vp_set(vp,name,(void *)copy,vp_str_destructor);
	/* in case of error vp_set will free the string... */
}

static void
vp_strl_destructor(void *object) {
	strl_t *tmp,*next;

	DPRINT(("vp_strl_destructor called\n"));
	for (tmp=(strl_t *)object;tmp;tmp=next) {
		next=tmp->next;
		free(tmp);
	}
}

int
vp_set_strl(varpool_t vp,char *name,strl_t *value) {
	return vp_set(vp,name,(void *)value,vp_strl_destructor);
}

int
vp_insert_strl(varpool_t vp,char *name,char *value) {
	strl_t *old,*new;

	new=(strl_t *)malloc(sizeof(strl_t)+strlen(value));
	if (new == NULL) {
		ERRLOG((LOG_ERR,"vp_set_strl: cannot alloc space for %s=\"%s\"",
							name,value));
		return -1;
	}
	new->next=NULL;
	strcpy(new->text,value);
	old=vp_get_strl(vp,name);
	if (old) {
		while (old->next) old=old->next;
		old->next=new;
		return 0;
	} else {
		return vp_set_strl(vp,name,new);
	}
}

void *
vp_get(varpool_t vp,char *name) {
	LHASH *lh=(LHASH *)vp;
	varobj_t lookup,*data;

	if (strlen(name) > (VP_MAXNAME-1)) {
		ERRLOG((LOG_ERR,"vp_set: too long name \"%s\"",name));
		return NULL;
	}
	strcpy(lookup.name,name);
	data=lh_retrieve(lh,(void *)&lookup);
	if (data) return data->object;
	else return NULL;
}

int
vp_get_int(varpool_t vp,char *name) {
	return (int)vp_get(vp,name);
}

char *
vp_get_str(varpool_t vp,char *name) {
	return (char *)vp_get(vp,name);
}

strl_t *
vp_get_strl(varpool_t vp,char *name) {
	return (strl_t *)vp_get(vp,name);
}
