#ifndef LINT
static char *rcsid="$Id: testiprl.c 404 2005-07-13 08:02:30Z crosser $";
#endif
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifndef OPTARG_DEFINED
# include <getopt.h>
#endif
#ifdef HAVE_REGEX_H
# include <regex.h>
#endif

#include "report.h"
#include "zmscanner.h"

int verbose=0;

static void
showver(char *name)
{
	fprintf(stderr,"%s Version %s Build %s\n",name,VERSION,__DATE__);
}

static void
showhelp(char *name)
{
	fprintf(stderr,"Usage: %s -V -v -h addr range ...\n",
							name);
	fprintf(stderr,"\t-V\t\t- print version\n");
	fprintf(stderr,"\t-v\t\t- increase verbosity\n");
	fprintf(stderr,"\t-h\t\t- print this help message\n");
}

main(int argc, char *argv[])
{
	int i,rc;
	char *addr,*le;
	iprangelist_t *iprl;

	while ((i=getopt(argc,argv,"I:vVh")) != EOF) switch (i) {
	case 'V':
		showver(argv[0]);
		return 0;
	case 'v':
		verbose++;
		break;
	case 'h':
		showhelp(argv[0]);
		return 0;
	default:
		showhelp(argv[0]);
		return 1;
	}

	if (argc-optind < 2) {
		showhelp(argv[0]);
		return 1;
	}

	addr=argv[optind++];
	printf("checking addr \"%s\" against this list:\n",addr);
	iprl=iprangelist_new();
	if (iprl == NULL) {
		fprintf(stderr,"iprangelist_new failed\n");
		return 1;
	}
	while ((le=argv[optind++])) {
		printf("\t\"%s\"\n",le);
		if (iprangelist_insert(iprl,rl_type_unknown,le)) {
			fprintf(stderr,"iprangelist_insert \"%s\" failed\n",le);
			return 1;
		}
	}
	rc=iprangelist_lookup(iprl,rl_type_unknown,addr);
	printf("result is: %s\n",rc?"true":"false");
	iprangelist_destroy(iprl);

	return rc;
}
