#ifndef LINT
static char *rcsid="$Id: scandata.c 266 2005-04-17 13:37:59Z crosser $";
#endif

/*
	$Log: scandata.c,v $
	Revision 1.3  2003/09/14 20:09:25  crosser
	varpool implementation, iteration 0
	
	Revision 1.2  2003/09/14 18:19:52  crosser
	use lhash to search stages
	
	Revision 1.1  2003/09/14 14:00:06  crosser
	begin introduction of lhash...
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include "config.h"
#ifdef STDC_HEADERS
# include <stdio.h>
# include <string.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif

#include "lhash.h"
#include "report.h"
#include "zmscanner.h"
#include "plugin.h"

int
scandata(char *stage,int depth,slab_t data,varpool_t vp)
{
	int rc=ZMSCAN_CONTINUE;
	struct _stage search_entry;
	struct _stage *sp;
	struct _plugin *pp;

	DPRINT(("scandata stage=%s depth=%d size=%d\n",
					stage,depth,slab_size(data)));
	if (strlen(stage) > (MAXNAME-1)) {
		ERRLOG((LOG_ERR,"scandata: stage name \"%s\" too long",stage));
		return ZMSCAN_CONTINUE;
	}
#if 1
	strcpy(search_entry.name,stage);
	sp=(struct _stage *)lh_retrieve(stagehash,(char*)&search_entry);
#else
	for (sp=stages;sp;sp=sp->next) {
		if (strcmp(stage,sp->name) == 0) break;
	}
#endif
	if (sp == NULL) return ZMSCAN_CONTINUE;
	for (pp=sp->plugin;pp;pp=pp->next) {
		rc=(pp->scan_func)(stage,depth,data,vp,pp->priv);
		if (rc != ZMSCAN_CONTINUE) break;
	}
	return rc;
}
