#ifndef LINT
static char *rcsid="$Id: iprl_v6.c 408 2005-07-13 17:16:31Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#include "zmscanner.h"
#include "iprl.h"

#ifdef AF_INET6

struct _any_addr {
	struct in6_addr a;
};

struct _any_range {
	struct _any_addr beg;
	struct _any_addr end;
};

static int
XleY(addr_t *x,addr_t *y)
{
	register unsigned char *l1=(x->a).in6_u.u6_addr8;
	register unsigned char *l2=(y->a).in6_u.u6_addr8;
	int i;

	for (i=0;i<16;i++) {
		if (l1[i] < l2[i]) return 1;
		if (l1[i] > l2[i]) return 0;
	}
	return 1;
}

static range_t *
NofR(int n,range_t *r)
{
	return &r[n];
}

static addr_t *
BEGofR(range_t *r)
{
	return &(r->beg);
}

static addr_t *
ENDofR(range_t *r)
{
	return &(r->end);
}

static int
NextSize(iprangelist_t *rl)
{
	if (((rl->count)+1)*sizeof(range_t) <= rl->size) return 0;
	if (rl->size == 0) return sizeof(range_t)*8;
	if (rl->size > sizeof(range_t)*128) return rl->size+sizeof(range_t)*128;
	return rl->size*2;
}

static void
MoveEl(range_t *t,range_t *f)
{
	memcpy(t,f,sizeof(range_t));
}

static void
MakeEl(range_t *r,addr_t *x,addr_t *y)
{
	memcpy(&(r->beg),x,sizeof(addr_t));
	memcpy(&(r->end),y,sizeof(addr_t));
}

int
init_v6_iprangelist(iprangelist_t *rl)
{
	rl->isactive=1;
	rl->XleY=XleY;
	rl->NofR=NofR;
	rl->BEGofR=BEGofR;
	rl->ENDofR=ENDofR;
	rl->NextSize=NextSize;
	rl->MoveEl=MoveEl;
	rl->MakeEl=MakeEl;
	return 0;
}

/* NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  */
/* The next procedure is completely undebugged and probably unoperational */
/* NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  */

int
v6_cidr2range(rl_type_t type,addr_t *addr,int bits,addr_t *beg,addr_t *end)
{
	unsigned char mask=~0;
	unsigned char allones=~0;
	unsigned char *s=(addr->a).in6_u.u6_addr8;
	unsigned char *b=(beg->a).in6_u.u6_addr8;
	unsigned char *e=(end->a).in6_u.u6_addr8;
	int wholebytes=bits/8;
	int partbits=bits%8;
	int i;

	if (partbits) mask<<=(8-partbits);
	else mask=0;
	allones&=mask;
	for (i=0;i<=wholebytes;i++) {
		b[i]=s[i];
		e[i]=s[i];
	}
	b[wholebytes]&=mask;
	e[wholebytes]|=allones;
	for (i=wholebytes+1;i<16;i++) {
		b[i]=0;
		e[i]=~0;
	}
	return 0;
}

#else /* AF_INET6 */

int
init_v6_iprangelist(iprangelist_t *rl)
{
	rl->isactive=0;
	return 0;
}

int
v6_cidr2range(rl_type_t type,addr_t *addr,int bits,addr_t *beg,addr_t *end)
{
	return 0;
}

#endif /* AF_INET6 */
