#ifndef LINT
static char *rcsid="$Id: iprl_v4.c 408 2005-07-13 17:16:31Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#include "zmscanner.h"
#include "iprl.h"

struct _any_addr {
	struct in_addr a;
};

struct _any_range {
	struct _any_addr beg;
	struct _any_addr end;
};

static int
XleY(addr_t *x,addr_t *y)
{
	return (htonl((x->a).s_addr) <= htonl((y->a).s_addr));
}

static range_t *
NofR(int n,range_t *r)
{
	return &r[n];
}

static addr_t *
BEGofR(range_t *r)
{
	return &(r->beg);
}

static addr_t *
ENDofR(range_t *r)
{
	return &(r->end);
}

static int
NextSize(iprangelist_t *rl)
{
	if (((rl->count)+1)*sizeof(range_t) <= rl->size) return 0;
	if (rl->size == 0) return sizeof(range_t)*8;
	if (rl->size > sizeof(range_t)*128) return rl->size+sizeof(range_t)*128;
	return rl->size*2;
}

static void
MoveEl(range_t *t,range_t *f)
{
	memcpy(t,f,sizeof(range_t));
}

static void
MakeEl(range_t *r,addr_t *x,addr_t *y)
{
	memcpy(&(r->beg),x,sizeof(addr_t));
	memcpy(&(r->end),y,sizeof(addr_t));
}

int
init_v4_iprangelist(iprangelist_t *rl)
{
	rl->isactive=1;
	rl->XleY=XleY;
	rl->NofR=NofR;
	rl->BEGofR=BEGofR;
	rl->ENDofR=ENDofR;
	rl->NextSize=NextSize;
	rl->MoveEl=MoveEl;
	rl->MakeEl=MakeEl;
	return 0;
}

int
v4_cidr2range(rl_type_t type,addr_t *addr,int bits,addr_t *beg,addr_t *end)
{
	unsigned long mask=~0UL;
	unsigned long allones=~0UL;
	unsigned long a;

	if (bits) mask <<= (32-bits);
	else mask=0UL;
	allones &= ~mask;

	a=htonl((addr->a).s_addr);
	a&=mask;
	(beg->a).s_addr=ntohl(a);
	a|=allones;
	(end->a).s_addr=ntohl(a);
	return 0;
}
