#ifndef LINT
static char *rcsid="$Id: iprl_read.c 425 2005-08-01 12:06:14Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif

#include "report.h"
#include "zmscanner.h"

int
iprangelist_read(iprangelist_t *rl,rl_type_t type,char *filename)
{
	FILE *fp;
	char buf[256];
	int count=0;
	int rc;

	DPRINT(("iprangelist_read: \"%s\"\n",filename));
	if ((fp=fopen(filename,"r"))) while (fgets(buf,sizeof(buf)-1,fp)) {
		char *p;

		count++;
		if (buf[0] == '#') continue;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		while ((p >= buf) && ((*p == '\r') || (*p == '\n') ||
				      (*p == ' ') || (*p == '\t'))) *p--='\0';
		if (buf[0] == '\0') continue;
		rc=iprangelist_insert(rl,type,buf);
		if (rc) {
			ERRLOG((LOG_ERR,"%s(%d): unparseable line \"%s\"",
				filename,count,buf));
			break;
		}
		fclose(fp);
	} else {
		ERRLOG((LOG_ERR,"open rangelist file \"%s\": %m",filename));
		rc=-1;
	}
	return rc;
}
