#ifndef LINT
static char *rcsid="$Id: iplist.c 397 2005-06-29 10:16:37Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#include "report.h"
#include "zmscanner.h"
#include "iprl.h"

/* parse string representation into ipaddr_any_t struct (given by caller) */
int
iprl_parsecaddr(rl_type_t *type,char *caddr,inany_addr_t *dest)
{
	int af=AF_INET;
	char *p;
	int rc;

	DPRINT(("iprl_parsecaddr(%d,\"%s\",%p)\n",*type,caddr,dest));
	p=caddr+strlen(caddr)-1;
	if (*caddr == '[' && *p == ']') {
		caddr++;
		*p='\0';
	}
	switch (*type) {
	case rl_type_v4:	af=AF_INET; break;
#ifdef AF_INET6
	case rl_type_v6:	af=AF_INET6; break;
#endif /* AF_INET6 */
	case rl_type_unknown:
#ifdef AF_INET6
		if (strchr(caddr,':')) {
			af=AF_INET6;
			(*type)=rl_type_v6;
		} else
#endif /* AF_INET6 */
		      {
			af=AF_INET;
			(*type)=rl_type_v4;
		}
		break;
	}
	rc=inet_pton(af,caddr,dest);
	DPRINT(("rc=%d, type=%d af=%d \"%s\"->\"%s\" at %p\n",
		rc,*type,af,caddr,iprl_printaddr(*type,dest),dest));
	if (rc > 0) return 0;
	else return -1;
}

int
iprl_parsecidr(rl_type_t *type,char *cidr,inany_addr_t *beg,inany_addr_t *end)
{
	inany_addr_t addr;
	char *mask;
	int bits;
	int rc;

	DPRINT(("iprl_parsecidr(%d,\"%s\",%p,%p)\n",*type,cidr,beg,end));
	if ((mask=strchr(cidr,'/'))) *mask++='\0';
	rc=iprl_parsecaddr(type,cidr,&addr);
	if (rc) return rc;
	bits=atoi(mask);
	switch (*type) {
	case rl_type_v4:
		rc=v4_cidr2range(*type,(addr_t*)&addr,bits,
				(addr_t*)beg,(addr_t*)end);
		break;
#ifdef AF_INET6
	case rl_type_v6:
		rc=v6_cidr2range(*type,(addr_t*)&addr,bits,
				(addr_t*)beg,(addr_t*)end);
		break;
#endif /* AF_INET6 */
	default:
		return 1;
		break;
	}
	return rc;
}

int
iprl_parsecrange(rl_type_t *type,char *crange,inany_addr_t *beg,inany_addr_t *end)
{
	char *p;
	int rc;

	DPRINT(("iprl_parsecrange(%d,\"%s\",%p,%p)\n",*type,crange,beg,end));
	if ((p=strchr(crange,'-'))) {
		*p++='\0';
		rc=iprl_parsecaddr(type,crange,beg);
		DPRINT(("after 1 parse rc=%d, type=%d \"%s\"->\"%s\" at %p\n",
			rc,*type,crange,iprl_printaddr(*type,beg),beg));
		if (rc) return rc;
		rc=iprl_parsecaddr(type,p,end);
		DPRINT(("after 2 parse rc=%d, type=%d \"%s\"->\"%s\" at %p\n",
			rc,*type,p,iprl_printaddr(*type,end),end));
		return rc;
	} else if ((p=strchr(crange,'/'))) {
		return iprl_parsecidr(type,crange,beg,end);
	} else {
		if ((rc=iprl_parsecaddr(type,crange,beg))) return rc;
		memcpy(end,beg,sizeof(inany_addr_t));
		return 0;
	}
}

char *
iprl_printaddr(rl_type_t type,addr_t *addr)
{
	static char buf[256];
	int af=AF_INET;

	switch (type) {
	case rl_type_v4:	af=AF_INET; break;
#ifdef AF_INET6
	case rl_type_v6:	af=AF_INET6; break;
#endif /* AF_INET6 */
	case rl_type_unknown:	af=AF_INET; break;
	}
	inet_ntop(af,addr,buf,sizeof(buf));
	return buf;
}
