#ifndef IPRL_H
#define IPRL_H "$Id: iprl.h 407 2005-07-13 16:57:09Z crosser $"

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

typedef union inany_addr {
	struct in_addr v4;
#ifdef AF_INET6
	struct in6_addr v6;
#endif /* AF_INET6 */
} inany_addr_t;

typedef struct _any_addr addr_t;
typedef struct _any_range range_t;

typedef int (XleY_t)(addr_t *x,addr_t *y);
typedef range_t *(NofR_t)(int n,range_t *r);
typedef addr_t *(BEGofR_t)(range_t *r);
typedef addr_t *(ENDofR_t)(range_t *r);
typedef int (NextSize_t)(iprangelist_t *rl);
typedef void (MoveEl_t)(range_t *t,range_t *f);
typedef void (MakeEl_t)(range_t *r,addr_t *x,addr_t *y);

struct _iprangelist {
	rl_type_t type;
	int isactive;
	XleY_t *XleY;
	NofR_t *NofR;
	BEGofR_t *BEGofR;
	ENDofR_t *ENDofR;
	NextSize_t *NextSize;
	MoveEl_t *MoveEl;
	MakeEl_t *MakeEl;
	int count;
	range_t *list;
	int size;
};

int init_v4_iprangelist(iprangelist_t *rl);
int init_v6_iprangelist(iprangelist_t *rl);
int v4_cidr2range(rl_type_t type,addr_t *addr,int bits,addr_t *beg,addr_t *end);
int v6_cidr2range(rl_type_t type,addr_t *addr,int bits,addr_t *beg,addr_t *end);
int iprl_parsecaddr(rl_type_t *type,char *caddr,inany_addr_t *dest);
int iprl_parsecidr(rl_type_t *type,char *cidr,
				inany_addr_t *beg,inany_addr_t *end);
int iprl_parsecrange(rl_type_t *type,char *crange,
				inany_addr_t *beg,inany_addr_t *end);
char *iprl_printaddr(rl_type_t type,addr_t *addr);

#endif /* IPRL_H */
