#ifndef LINT
static char *rcsid="$Id: iprl.c 407 2005-07-13 16:57:09Z crosser $";
#endif

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_STDDEF_H
# include <stddef.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_ARPA_INET_H
# include <arpa/inet.h>
#endif
#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#include "report.h"
#include "zmscanner.h"
#include "iprl.h"

#undef EXPENSIVE_DEBUG

/* in the following private functions, `rl' is an already selected
   element of array of rangelists */

static int
nearestbeg(iprangelist_t *rl,addr_t *addr)
{
	int lo,hi,cur;

#ifdef EXPENSIVE_DEBUG
	DPRINT(("nearestbeg(%p,%s)\n",rl,iprl_printaddr(rl->type,addr)));
#endif
	lo=-1;
	hi=rl->count;
	while (hi-lo > 1) {
		cur=lo+(hi-lo)/2;
#ifdef EXPENSIVE_DEBUG
		DPRINT(("halve: lo=%d, hi=%d, cur=%d\n",lo,hi,cur));
		DPRINT(("compare to beg addr %s\n",
			iprl_printaddr(rl->type,
				(rl->BEGofR)((rl->NofR)(cur,rl->list)))));
#endif
		if ((rl->XleY)((rl->BEGofR)((rl->NofR)(cur,rl->list)),addr))
			lo=cur;
		else
			hi=cur;
#ifdef EXPENSIVE_DEBUG
		DPRINT(("halve: after check lo=%d, hi=%d\n",lo,hi));
#endif
	}
#ifdef EXPENSIVE_DEBUG
	DPRINT(("nearestbeg about to return lo=%d\n",lo));
#endif
	return lo;
}

static int
isinside(iprangelist_t *rl,addr_t *addr)
{
	int i;
	int rc;

#ifdef EXPENSIVE_DEBUG
	DPRINT(("isinside(%p,%s)\n",rl,iprl_printaddr(rl->type,addr)));
#endif
	i=nearestbeg(rl,addr);
	if (i < 0) return 0;
	rc=(rl->XleY)(addr,(rl->ENDofR)((rl->NofR)(i,rl->list)));
#ifdef EXPENSIVE_DEBUG
	DPRINT(("checked candidate %d (%s,",i,iprl_printaddr(rl->type,(rl->BEGofR)((rl->NofR)(i,rl->list)))));
	DPRINT(("%s), result is %d\n",iprl_printaddr(rl->type,(rl->ENDofR)((rl->NofR)(i,rl->list))),rc));
#endif
	return rc;
}

static int
mergerange(iprangelist_t *rl,addr_t *beg,addr_t *end)
{
	int i;
	int needtogrow;
	int newsize=0;

#ifdef EXPENSIVE_DEBUG
	DPRINT(("mergerange(%p,%s,",rl,iprl_printaddr(rl->type,beg)));
	DPRINT(("%s)\n",iprl_printaddr(rl->type,end)));
#endif
	i=nearestbeg(rl,beg);
	if ((i >= 0) && (rl->XleY)(beg,(rl->ENDofR)((rl->NofR)(i,rl->list))))
		needtogrow=0;
	else
		needtogrow=1;
	if (needtogrow) newsize=(rl->NextSize)(rl);
#ifdef EXPENSIVE_DEBUG
	DPRINT(("mergerange pos=%d grow=%d nsize=%d (count=%d, osize=%d)\n",
		i,needtogrow,newsize,rl->count,rl->size));
#endif
	if (newsize) {
		rl->list=(range_t*)realloc(rl->list,newsize);
		if (rl->list == NULL) {
			ERRLOG((LOG_ERR,"no memory to grow rangelist to %d",
					rl->size));
			return 1;
		}
		rl->size=newsize;
	}
	if (needtogrow) {
		/* push everything down and insert a new entry */
		int j;

		i++;
		for (j=rl->count;j>i;j--) {
#ifdef EXPENSIVE_DEBUG
			DPRINT(("move el %d to %d\n",j-1,j));
#endif
			(rl->MoveEl)((rl->NofR)(j,rl->list),
					(rl->NofR)(j-1,rl->list));
		}
		DPRINT(("fill new elem at pos %d\n",i));
		(rl->MakeEl)((rl->NofR)(i,rl->list),beg,end);
		rl->count++;
	} else {
		/* merge next entry(ies) with the new one */
		int j,shrink;

		shrink=-1; /* we know there is at least 1 intersection */
		for (j=i;
		     (rl->XleY)(beg,(rl->ENDofR)((rl->NofR)(j,rl->list))) &&
		     (rl->XleY)((rl->BEGofR)((rl->NofR)(j,rl->list)),end);
		     j++,shrink++) {
			if (j >= rl->count) break;
#ifdef EXPENSIVE_DEBUG
			DPRINT(("intersection: el %d\n",j));
#endif
			if ((rl->XleY)((rl->BEGofR)((rl->NofR)(j,rl->list)),beg))
				beg=(rl->BEGofR)((rl->NofR)(j,rl->list));
#ifdef EXPENSIVE_DEBUG
			DPRINT(("new beg=%s\n",iprl_printaddr(rl->type,beg)));
#endif
			if ((rl->XleY)(end,(rl->ENDofR)((rl->NofR)(j,rl->list))))
				end=(rl->ENDofR)((rl->NofR)(j,rl->list));
#ifdef EXPENSIVE_DEBUG
			DPRINT(("new end=%s\n",iprl_printaddr(rl->type,end)));
#endif
		}
		(rl->MakeEl)((rl->NofR)(i,rl->list),beg,end);
#ifdef EXPENSIVE_DEBUG
		DPRINT(("after merge: i=%d, j=%d shrink=%d\n",i,j,shrink));
#endif
		i++;
		for (;j<rl->count;i++,j++) {
#ifdef EXPENSIVE_DEBUG
			DPRINT(("move el %d to %d\n",j,i));
#endif
			(rl->MoveEl)((rl->NofR)(i,rl->list),
					(rl->NofR)(j,rl->list));
		}
		rl->count-=shrink;
	}
#ifdef EXPENSIVE_DEBUG
	DPRINT(("mergerange new element=%d new count=%d new size=%d\n",
		i,rl->count,rl->size));
#endif
	return 0;
}

/* P U B L I C   F U N C T I O N S */

/* In all functions, type argument may specify v4/v6 address.
   If rl_type_unknown is passed, type is guessed from the address syntax.
   `rl' is the start element of array of rangelists */

/* Create empty iprangelist_t object */
iprangelist_t *
iprangelist_new(void)
{
	rl_type_t i;
	iprangelist_t *rl;
	int memsize;

	memsize=sizeof(iprangelist_t)*(RL_MAX+1);
	rl=(iprangelist_t*)malloc(memsize);
	DPRINT(("iprangelist_new %d bytes for 0..%d array of %d at %p\n",
		memsize,RL_MAX,sizeof(iprangelist_t),rl));
	if (rl == NULL) {
		ERRLOG((LOG_ERR,"iprangelist_new could not alloc %d bytes: %m",
			memsize));
		return NULL;
	}
	for (i=0;i<=RL_MAX;i++) {
		memset(&(rl[i]),0,sizeof(iprangelist_t));
		rl[i].type=i;
		switch (i) {
		case rl_type_v4:
			init_v4_iprangelist(&(rl[i]));
			DPRINT(("iprangelist_new inited v4(%d) at %p\n",
				i,&(rl[i])));
			break;
		case rl_type_v6:
			init_v6_iprangelist(&(rl[i]));
			DPRINT(("iprangelist_new inited v6(%d) at %p\n",
				i,&(rl[i])));
			break;
		default:
			DPRINT(("iprangelist_new unknown(%d) at %p\n",
				i,&(rl[i])));
			break;
		}
	}
	DPRINT(("iprangelist_new return rl at %p\n",rl));
	return rl;
}

/* Free iprangelist_t object */
void
iprangelist_destroy(iprangelist_t *rl)
{
	int i;

	if (rl == NULL) {
		ERRLOG((LOG_ERR,"iprangelist_destroy: "
					"trying to destroy null object"));
		return;
	}
	for (i=0;i<=RL_MAX;i++)
		if (rl[i].isactive && rl[i].size) free(rl[i].list);
	free(rl);
	return;
}

/* Insert a range into existing iprangelist_t object, taking care of
   growing memory area if necessary, and merging overlapping ranges.
   Result is sorted list ready for lookup. */
int
iprangelist_insert(iprangelist_t *rl,rl_type_t type,char *crange)
{
	inany_addr_t beg,end;
	int rc;

	DPRINT(("iprangelist_insert(%p,%d,\"%s\")\n",rl,type,crange));
	DPRINT(("buffers at beg=%p, end=%p %d bytes each\n",
		&beg,&end,sizeof(beg)));
#if 0
	return 0;
#endif
	rc=iprl_parsecrange(&type,crange,&beg,&end);
	DPRINT(("after parsecrange type=%d, beg=%s,",
		type,iprl_printaddr(type,&beg)));
	DPRINT((" end=%s rc=%d\n",iprl_printaddr(type,&end),rc));
	if (rc) return rc;
	if (type == rl_type_unknown) {
		ERRLOG((LOG_ERR,"parse_crange did not fill addr type for %s",
				crange));
		return -1;
	}
	rl=&(rl[type]);
	DPRINT(("iprangelist_insert type=%d, rl el=%p\n",type,rl));
	return mergerange(rl,(addr_t*)&beg,(addr_t*)&end);
}

/* check if caddr is inside any of ranges in the list, return 1 if yes */
int
iprangelist_lookup(iprangelist_t *rl,rl_type_t type,char *caddr)
{
	inany_addr_t addr;

	DPRINT(("iprangelist_lookup(%p,%d,\"%s\")\n",rl,type,caddr));
#if 0 /* TEMP HACK - 127.* is whitelisted */
	return (!strncmp(caddr,"127.",4));
#endif /* END TEMP HACK */
	if (iprl_parsecaddr(&type,caddr,&addr)) {
		ERRLOG((LOG_ERR,"iprangelist_lookup: "
				"unparsable string \"%s\"",caddr));
		return 0;
	}
	rl=&(rl[type]);
	if (type > RL_MAX || !rl->isactive) {
		ERRLOG((LOG_ERR,"iprangelist_lookup: "
				"trying to use nonexistent list "
				"type=%d, isactive=%d",type,rl->isactive));
		return 0;
	}
	DPRINT(("iprangelist_lookup type=%d, rl el=%p\n",type,rl));
	return isinside(rl,(addr_t*)&addr);
}
