#ifndef ZMSCANNER_H
#define ZMSCANNER_H "$Id: zmscanner.h 425 2005-08-01 12:06:14Z crosser $"

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

size_t
strlcpy(char *dst,const char *src,size_t siz);

typedef struct _slab slab_t;

/* ************************************************************************
	V A R P O O L functions

DOCUMENTATION (kind of):

vp_set_str() creates a *copy* of the string.  Don't allocate yourself
vp_set() does not allocate object (it dows not know how).  Create yourself.
vp_set() *calls destructor* if it cannot insert the object (and returns -1)
	Don't try to destruct it yourself again!
vp_set() destructs any previously existing object with the same name

*/

#define VP_MAXNAME 32
#define VP_ANSWER_STR "zms_answer_string"
#define VP_ADDHEADERS_STRL "zms_addheaders_strl"

typedef struct _varobj {
	char name [VP_MAXNAME];
	void *object;
	void (*destructor)(void *);
} varobj_t;

typedef void * varpool_t;

extern varpool_t
vp_create_vp(void);
extern void
vp_destroy_vp(varpool_t vp);

typedef struct _strl {
	struct _strl *next;
	char text[1];
} strl_t;

extern int
vp_set(varpool_t vp,char *name,void *object,void (*destructor)(void *));
extern int
vp_set_int(varpool_t vp,char *name,int value);
extern int
vp_set_str(varpool_t vp,char *name,char *value);
extern int
vp_set_strl(varpool_t vp,char *name,strl_t *value);
extern int
vp_insert_strl(varpool_t vp,char *name,char *value);

extern void *
vp_get(varpool_t vp,char *name);
extern int
vp_get_int(varpool_t vp,char *name);
extern char *
vp_get_str(varpool_t vp,char *name);
extern strl_t *
vp_get_strl(varpool_t vp,char *name);

/* ********************************************************************* */

/* I P R A N G E   F U N C T I O N S */

typedef struct _iprangelist iprangelist_t;
typedef enum {rl_type_unknown=-1,rl_type_v4,rl_type_v6} rl_type_t;
#define RL_MAX (rl_type_v6)
extern iprangelist_t *iprangelist_new(void);
extern void iprangelist_destroy(iprangelist_t *rl);
/* crange is character representation of a range: single address,
   start and end connected by a '-' or CIDR (addr/maskbits) */
extern int iprangelist_insert(iprangelist_t *rl,rl_type_t type,char *crange);
/* read range data from a file - one range per line */
extern int iprangelist_read(iprangelist_t *rl,rl_type_t type,char *filename);
/* lookup return 1 (true) if address is inside a range in the list */
extern int iprangelist_lookup(iprangelist_t *rl,rl_type_t type,char *caddr);

/* ********************************************************************* */

/* O T H E R   Z M A C A N N E R   S T U F F */

struct _slab {
	char *beg;
	char *end;
	void *atr;
};

#define slab_size(x) ((x).end-(x).beg)

typedef enum {t_single, t_multipart, t_message} btype_t;
typedef enum {e_plain, e_qp, e_base64, e_uue} benc_t;
typedef struct _matr {
	btype_t btype;
	benc_t benc;
	slab_t boundary;
	slab_t content_type;
	slab_t name;
	slab_t charset;
	int usefirst;
	int type_set;
	int enc_set;
} mattr_t;

extern void
initattr(mattr_t *newattr,mattr_t *oldattr);

extern char *
modconfdir(void);

extern void
init_plugins(void);

extern void
term_plugins(void);

extern int
register_plugin(char *stage,char *name,
		int (*init_func)(void **priv),
		void (*term_func)(void **priv),
		int (*scan_func)(char *stage,int depth,
				slab_t data,varpool_t vp,void *priv));

extern int
scandata(char *stage,int depth,slab_t data,varpool_t vp);

#define ZMSCAN_CONTINUE	0
#define ZMSCAN_STOP	-1

#ifdef STATICMODULE
# define ZMS_MODULE(stage,name,init_func,term_func,scan_func) \
	void STATICMODULE (void) \
		{register_plugin(stage,name,init_func,term_func,scan_func);}
# define ZMS_MODINIT_FUNC void STATICMODULE (void)
#else
# define ZMS_MODULE(stage,name,init_func,term_func,scan_func) \
	void zms_mod_init(void) \
		{register_plugin(stage,name,init_func,term_func,scan_func);}
# define ZMS_MODINIT_FUNC void zms_mod_init (void)
#endif

#define ZMS_CLAIM_STAGE(stage,name,init_func,term_func,scan_func) \
	register_plugin(stage,name,init_func,term_func,scan_func)

#endif
