#ifndef LINT
static char *rcsid="$Id: zmschat.c 397 2005-06-29 10:16:37Z crosser $";
#endif
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2005 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
# include <sys/socket.h>
# include <sys/un.h>
#ifndef OPTARG_DEFINED
# include <getopt.h>
#endif
#ifdef HAVE_REGEX_H
# include <regex.h>
#endif

#include "report.h"
#include "rtconfig.h"
#include "zmscanner.h"
#include "daemon.h"

int verbose=0;
static char *configfile=DEFAULT_CONFIG;

static void
showver(char *name)
{
#ifdef HAVE_PTHREAD
# define _PTHR "(threaded)"
#else
# define _PTHR "(forking)"
#endif
	fprintf(stderr,"%s %s Version %s Build %s\n",
					name,_PTHR,VERSION,__DATE__);
}

static void
showhelp(char *name)
{
	fprintf(stderr,"Usage: %s -I configfile -V -v -h send[:expect] ...\n",
							name);
	fprintf(stderr,"\t-I configfile\t- path to config [default: %s]\n",
							DEFAULT_CONFIG);
	fprintf(stderr,"\t-V\t\t- print version\n");
	fprintf(stderr,"\t-v\t\t- increase verbosity\n");
	fprintf(stderr,"\t-h\t\t- print this help message\n");
}

int
tread(int msgsock,char *buf,int bufsize,int sec10) {
	fd_set ifd,ofd,efd;
	struct timeval timeout;
	int rc;
	char *p=buf;
	int left=bufsize-1;

	while (left) {
		FD_ZERO(&ifd);
		FD_ZERO(&ofd);
		FD_ZERO(&efd);
		FD_SET(msgsock,&ifd);
		timeout.tv_sec=sec10/10;
		timeout.tv_usec=(sec10%10)*100000;
		if ((rc=select(msgsock+1,&ifd,&ofd,&efd,&timeout)) == -1) {
			perror("select");
			return -1;
		} else if (rc == 0) {
			fprintf(stderr,"tread timeout\n");
			return -1;
		} else {
			if (FD_ISSET(msgsock,&ifd)) {
				if ((rc=read(msgsock,p,1)) < 0) {
					perror("read");
					return rc;
				} else if (rc == 0) {
					fprintf(stderr,"remote gone\n");
					return -1;
				}
				if (*p == '\n') {
					*p='\0';
					/*DPRINT(("tread got \"%s\"\n",buf));*/
					return p-buf;
				}
				p+=rc;
				left-=rc;
			} else {
				fprintf(stderr,"panic! Why did select exit?!\n");
				return -1;
			}
		}
	}
	return bufsize;
}

int
main(int argc, char *argv[])
{
	char *arg,*p;
	int rc,i,jcnt;
	int msgsock=-1;
	struct sockaddr_un server;
	char cmd[256],resp[256],buf[256];
	int errors=0;
	regex_t preg;

	while ((i=getopt(argc,argv,"I:vVh")) != EOF) switch (i) {
	case 'I':
		/* if someone decides to modify the name displayed in
		   the "ps" output it may be useful to copy the arg... */
		configfile=(char *)malloc(strlen(optarg)+1);
		strcpy(configfile,optarg);
		break;
	case 'V':
		showver(argv[0]);
		return 0;
	case 'v':
		verbose++;
		break;
	case 'h':
		showhelp(argv[0]);
		return 0;
	default:
		showhelp(argv[0]);
		return 1;
	}

	readconfig(configfile,0);

	memset((char *)&server,0,sizeof(server));
	server.sun_family = AF_UNIX;
	strlcpy(server.sun_path,gcfg.socket,sizeof(server.sun_path));
	if ((msgsock=socket(AF_UNIX,SOCK_STREAM,0)) < 0) {
		perror("socket");
		return 1;
	}
	if (connect(msgsock,(struct sockaddr *)&server,
		sizeof(server)-sizeof(server.sun_path)+
					strlen(server.sun_path)+1) < 0) {
		perror("connect");
		return 1;
	}

	while ((arg=argv[optind++])) {
		DPRINT(("next arg: \"%s\"\n",arg));
		jcnt=0;
		while (tread(msgsock,resp,sizeof(resp),2) > 0) {
			DPRINT(("expecting #hungry got \"%s\"\n",resp));
			if (strncmp(resp,"#hungry",7) == 0) break;
			if (jcnt++ > 5) {
				fprintf(stderr,"no \"#hungry\", abort\n");
				exit(-1);
			}
		}

		if ((p=strchr(arg,':'))) *p++='\0';

		snprintf(cmd,sizeof(cmd),"%s\n",arg);
		printf("    >> %s",cmd);
		write(msgsock,cmd,strlen(cmd));
		if (tread(msgsock,resp,sizeof(resp),25) > 0) {
			DPRINT(("got: \"%s\"\n",resp));
		} else {
			fprintf(stderr,"did not get answer\n");
			errors++;
		}
		if (p) {
			if ((rc=regcomp(&preg,p,0))) {
				regerror(rc,&preg,buf,sizeof(buf));
				fprintf(stderr,"regcomp error on \"%s\": %s\n",
							p,buf);
				errors++;
				continue;
			}
			switch ((rc=regexec(&preg,resp,0,NULL,0))) {
			case 0:
				printf("OK  << %s\n",resp);
				break;
			case REG_NOMATCH:
				printf("ERR << %s\n",resp);
				errors++;
				break;
			default:
				regerror(rc,&preg,buf,sizeof(buf));
				fprintf(stderr,"regexec error on \"%s\": %s\n",
							resp,buf);
				errors++;
				break;
			}
			regfree(&preg);
		} else {
			printf("    << %s\n",resp);
		}
	}

	close(msgsock);
	return errors;
}
