#ifndef LINT
static char *rcsid="$Id: processfile.c 421 2005-07-28 13:32:33Z crosser $";
#endif
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#ifdef HAVE_SYS_MMAN_H
# include <sys/mman.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif

#include "rtconfig.h"
#include "report.h"
#include "zmscanner.h"
#include "daemon.h"

#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
extern char q_file[];
#endif

void
processfile(char *fn,varpool_t vp)
{
	int msgfd;
	char *msgdata;
	struct stat stbuf;
	off_t msgsize;
	slab_t data;
	mattr_t attr;
	char rbuf[256];
	static char *nul="nul";
#ifndef HAVE_MMAP
	int len,rest;
	char *ptr;
#endif

	if ((msgfd=open(fn,O_RDONLY)) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: open error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	if (fstat(msgfd,&stbuf) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: fstat error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	msgsize=stbuf.st_size;
	if (msgsize == 0) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: zero size! no data, no scan",
				fn);
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	DPRINT(("real message size %d\n",(int)msgsize));
	if (msgsize > gcfg.maxsize) msgsize=gcfg.maxsize;
	DPRINT(("scanning %d first bytes\n",(int)msgsize));
	taspoolid(rbuf,stbuf.st_mtime,stbuf.st_ino);
	DPRINT(("setting spoolid var to \"%s\"\n",rbuf));
	vp_set_str(vp,"spoolid",rbuf);
	DPRINT(("setting myfqdn var to \"%s\"\n",myfqdn));
	vp_set_str(vp,"myfqdn",myfqdn);
#ifdef HAVE_MMAP
	if ((msgdata=(char*)mmap((void*)0,msgsize,PROT_READ,
				MAP_SHARED,msgfd,(off_t)0)) == NULL) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: mmap error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
#else /* HAVE_MMAP */
	if ((msgdata=malloc(msgsize)) == NULL) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: malloc(%d) error %d (%s)",
				fn,msgsize,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	ptr=msgdata;
	rest=msgsize;
	while (rest) {
		len=read(msgfd,ptr,rest);
		if (len <= 0) break;
		ptr+=len;
		rest-=len;
	}
	if (rest) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: read error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
#endif /* HAVE_MMAP */

	initattr(&attr,NULL);
	attr.usefirst=gcfg.firstmimehdr;
	memset(&data,0,sizeof(data));
	data.beg=msgdata;
	data.end=msgdata+msgsize;
	data.atr=(void *)&(attr);
        snprintf(rbuf,sizeof(rbuf),"0 250 Acceptable");

#if defined(DEBUG_LINK) && !defined(HAVE_PTHREAD)
	strlcpy(q_file,fn,256);
#endif

	(void)scandata(gcfg.initstage,0,data,vp);
	data.beg=nul;
	data.end=nul+strlen(nul);
	(void)scandata(gcfg.finalstage,0,data,vp);

#ifdef HAVE_MMAP
	if (munmap(msgdata,msgsize) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: munmap error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
#else
	free(msgdata);
#endif
	if (close(msgfd) == -1) {
		snprintf(rbuf,sizeof(rbuf),
				"0 250 Oops: %s: close error %d (%s)",
				fn,errno,strerror(errno));
		vp_set_str(vp,VP_ANSWER_STR,rbuf);
		return;
	}
	return;
}
