#ifndef LINT
static char *rcsid="$Id: myfqdn.c 423 2005-07-28 13:40:33Z crosser $";
#endif
                                                                                
/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_SYS_UTSNAME_H
# include <sys/utsname.h>
#endif
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif

void getmyfqdn(char *name, size_t len,char *confdomain)
{
#ifdef HAVE_UNAME
	struct utsname uts;
#endif
#if defined(HAVE_GETHOSTNAME) && !defined(HAVE_UNAME)
	char hostname[64];
#else
# define hostname uts.nodename
#endif
#if defined(HAVE_GETDOMAINNAME) && !defined(HAVE_STRUCT_UTSNAME_DOMAINNAME)
	char domainname[64];
#else
# define domainname uts.domainname
#endif
	char *domain;
	char *p;
	int rc;

#if defined(HAVE_UNAME)
	rc=uname(&uts);
#elif defined(HAVE_GETHOSTNAME)
	rc=gethostname(hostname,sizeof(hostname));
#endif
	if ((p=strchr(hostname,'.'))) *p='\0';
	if (confdomain) {
		domain=confdomain;
	} else if (p) {
		domain=p+1;
	} else {
#if defined(HAVE_GETDOMAINNAME) && !defined(HAVE_STRUCT_UTSNAME_DOMAINNAME)
		rc=getdomainname(domainname,sizeof(domainname));
#endif
		domain=domainname;
	}
#ifdef HAVE_NETDB_H
	if (!domainname || !strchr(domainname,'.')) {
		struct hostent *h1,*h2;
		int i;

		h1=gethostbyname(hostname);
		if (h1) {
			h2=gethostbyaddr(h1->h_addr,h1->h_length,
						h1->h_addrtype);
			if (h2) {
				if ((p=strchr(h2->h_name,'.'))) {
					domain=p+1;
				} else for (i=0;h2->h_aliases[i];i++) {
					if ((p=strchr(h2->h_aliases[i],'.'))) {
						domain=p+1;
						break;
					}
				}
			}
		}
	}
#endif
	if (!domain) domain="localdomain";
	snprintf(name,len-1,"%s.%s",hostname,domain);
}
