#ifndef LINT
static char *rcsid="$Id: mainloop.c 299 2005-05-14 09:33:21Z crosser $";
#endif
                                                                                
/*
	$Log: mainloop.c,v $
	Revision 1.17  2004/06/13 10:21:00  crosser
	clean up pthread check
	
	Revision 1.16  2003/09/15 13:32:49  crosser
	make reporting more logical with varpool: just set a variable with
	predefined name and it will go to the SMTP peer!
	
	Revision 1.15  2003/09/13 18:35:03  crosser
	report config errors to syslog (because if we are respawning there
	is not stderr).  Compile-time warnings.
	
	Revision 1.14  2003/09/13 18:18:03  crosser
	more proper syslogging
	
	Revision 1.13  2003/09/11 19:24:09  crosser
	no 1sec sleep before shutdown if there is no need
	
	Revision 1.12  2003/09/03 19:41:39  crosser
	work in progress on changed calling conventions
	
	Revision 1.11  2003/09/03 14:42:12  crosser
	do not report broken pipe
	release 0.02
	
	Revision 1.10  2003/09/03 10:25:55  crosser
	Zmailer is picky about surplus carriage return
	
	Revision 1.9  2003/08/31 18:43:23  crosser
	make the thing run in "filter" mode - from stdin to stdout
	
	Revision 1.8  2003/08/31 13:51:12  crosser
	header autoconfing cleanups
	
	Revision 1.7  2003/08/31 12:58:58  crosser
	make basic separation of lib/ plugins
	configure REPLACE_FUNCS in a right way (hopefully)
	
	Revision 1.6  2003/08/31 11:48:46  crosser
	filling inc and lib
	
	Revision 1.5  2003/08/25 10:18:41  crosser
	avoid race condition with thread counter when creating new thread
	
	Revision 1.4  2003/08/25 10:03:10  crosser
	in threaded version, make master thread wait for subthreads
	make thing compile without termios (but zmsctl won't work in fact)
	
	Revision 1.3  2003/08/24 21:25:33  crosser
	make processfile function
	
	Revision 1.2  2003/08/24 21:07:17  crosser
	created the whole async infrastructure
	
	Revision 1.1  2003/08/22 18:45:25  crosser
	main loop
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#include <sys/types.h>
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#ifdef STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif
#include <signal.h>
#ifdef HAVE_SYS_SOCKET_H
# include <sys/socket.h>
# include <sys/un.h>
#endif
#ifndef OPTARG_DEFINED
#include <getopt.h>
#endif
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif

#include "report.h"
#include "zmscanner.h"
#include "daemon.h"

#define HUNGRY "#hungry\n"

#ifdef HAVE_PTHREAD
static pthread_mutex_t cmutex=PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t ccond=PTHREAD_COND_INITIALIZER;
static int thrcount=0;
#endif

struct _priv {
	int msgsock;
};

void*
asyncserve(void *data)
{
	struct _priv *priv=(struct _priv*)data;
	int msgsock=priv->msgsock;
	int wrsock;
	char buf[256],rbuf[256],*p;
	size_t len;
	varpool_t vp;
	char *ans;

#ifdef HAVE_PTHREAD
	pthread_mutex_lock(&cmutex);
	thrcount++;
	pthread_mutex_unlock(&cmutex);
#endif
	if (msgsock) wrsock=msgsock;
	else wrsock=1; /* STDOUT */

	while (1) {
		if ((len=write(wrsock,HUNGRY,strlen(HUNGRY))) != strlen(HUNGRY)) {
			if (errno != EPIPE)
				ERRLOG((LOG_ERR,"write to socket: %m"));
			goto exit;
		}
		buf[0]='\0';
		if ((len=read(msgsock,buf,sizeof(buf)-1)) > 0) {
			buf[len]='\0';
			p=buf+strlen(buf)-1;
			while ((*p == '\n') || (*p == '\r')) *p--='\0';
			DPRINT(("request: %s\n",buf));
			if ((vp=vp_create_vp()) == NULL) {
				ERRLOG((LOG_ERR,"vp_create_vp failed"));
				snprintf(rbuf,sizeof(rbuf),
					"0 250 Oops: %s: vp_create_vp falied",
					buf);
			} else {
				DPRINT(("varpool at %p\n",vp));
#if 0
				vp_set_str(vp,VP_ANSWER_STR,"0 250 Acceptable");
#endif
				processfile(buf,vp);
				if ((ans=vp_get_str(vp,VP_ANSWER_STR))) {
					strncpy(rbuf,ans,sizeof(rbuf)-2);
				} else {
					strncpy(rbuf,
						"0 250 Accepted",
						sizeof(rbuf)-2);
				}
				rbuf[sizeof(rbuf)-2]='\0';
				vp_destroy_vp(vp);
			}
			DPRINT(("result : %s\n",rbuf));
			strcat(rbuf,"\n");
			write(wrsock,rbuf,strlen(rbuf));
		} else {
			if  (len < 0) {
				ERRLOG((LOG_ERR,"read from socket: %m"));
			} else {
				DPRINT(("remote gone\n"));
			}
			break;
		}
	}
exit:
	free(data);
	close(msgsock);
#ifdef HAVE_PTHREAD
	pthread_mutex_lock(&cmutex);
	thrcount--;
	if (thrcount <= 0) {
		pthread_cond_signal(&ccond);
	}
	pthread_mutex_unlock(&cmutex);
#endif
	return NULL;
}

void
serveclient(int ctlsock)
{
	struct sockaddr_un from;
	int flen=sizeof(from);
	int msgsock;
	struct _priv {
		int msgsock;
	} *privptr;
#ifdef HAVE_PTHREAD
	pthread_t thread;
	pthread_attr_t attr;
#else
	pid_t child;
#endif

	DPRINT(("serveclient called, sock %d\n",ctlsock));
	privptr=(struct _priv*)malloc(sizeof(struct _priv));
	msgsock=accept(ctlsock,(struct sockaddr*)&from,&flen);
	if ((msgsock < 0) && (errno == ENOTSOCK)) {
		privptr->msgsock=ctlsock;
		(void)asyncserve((void*)privptr);
		stayalive=0;
		return;
	}
	if (msgsock < 0) {
		ERRLOG((LOG_ERR,"accept: %d (%m)",errno));
		return;
	}
	DPRINT(("accepted sock %d\n",msgsock));
	privptr->msgsock=msgsock;
	
#ifdef HAVE_PTHREAD
	if (pthread_attr_init(&attr) < 0) {
		ERRLOG((LOG_ERR,"pthread_attr_init: %m"));
	}
	if (pthread_attr_setdetachstate(&attr,PTHREAD_CREATE_DETACHED) < 0) {
		ERRLOG((LOG_ERR,"pthread_attr_setdetachstate: %m"));
	}
	pthread_mutex_lock(&cmutex);
	thrcount++;
	pthread_mutex_unlock(&cmutex);
	if (pthread_create(&thread,&attr,asyncserve,(void*)privptr) < 0) {
		ERRLOG((LOG_ERR,"pthread_create: %m"));
	} else {
		DPRINT(("asyncserve started new thread\n"));
	}
	pthread_mutex_lock(&cmutex);
	thrcount--;
	if (thrcount <= 0) {
		pthread_cond_signal(&ccond);
	}
	pthread_mutex_unlock(&cmutex);
#else /* HAVE_PTHREAD */
	if ((child=fork()) == 0) {
		(void)asyncserve((void*)privptr);
		exit(0);
	} else {
		if (child < 0) {
			ERRLOG((LOG_ERR,"forking asyncserve: %m"));
		} else {
			DPRINT(("forked asyncserve as child %d\n",child));
		}
		free(privptr);
		close(msgsock);
	}
#endif /* HAVE_PTHREAD */
}

int
mainloop(int ctlsock,int argc, char *argv[])
{
	fd_set rfds,wfds,efds;
	time_t now;
	int rc;

	(void)time(&now);
	if (ctlsock == 0) serveclient(ctlsock);
	else while (stayalive) {
		FD_ZERO(&rfds);
		FD_ZERO(&wfds);
		FD_ZERO(&efds);
		FD_SET(ctlsock,&rfds);
		rc=select(ctlsock+1,&rfds,&wfds,&efds,NULL);
		if (rc >= 0) (void)time(&now);
		if (rc > 0) {
			if (FD_ISSET(ctlsock,&rfds)) {
				serveclient(ctlsock);
			} else {
				ERRLOG((LOG_WARNING,
					"spurious event on fd=%d",ctlsock));
			}
		} else if (rc == 0) {
			ERRLOG((LOG_WARNING,"spurious timeout on select"));
		} else if ((rc == -1) && (errno == EINTR)) {
			if (runchild) {
				runchild=0;
				ERRLOG((LOG_INFO,"respawn requestd"));
				givebirth(ctlsock,argc,argv);
			} else if (!stayalive) {
				ERRLOG((LOG_INFO,"shutdown requestd"));
			} else {
				ERRLOG((LOG_INFO,"select interrupted"));
			}
		} else {
			ERRLOG((LOG_ERR,"select failure: %m"));
		}
	}

#ifdef HAVE_PTHREAD
	pthread_mutex_lock(&cmutex);
	while (thrcount > 0) {
		DPRINT(("waiting for thrcount=%d to become zero\n",thrcount));
		pthread_cond_wait(&ccond,&cmutex);
		DPRINT(("ccond signalled\n"));
	}
	pthread_mutex_unlock(&cmutex);
	DPRINT(("thrcount dropped to zero, finish\n"));
	pthread_mutex_destroy(&cmutex);
	pthread_cond_destroy(&ccond);
#endif
	return 0;
}
