#ifndef LINT
static char *rcsid="$Id";
#endif
                                                                                
/*
	$Log: clamav_config.c,v $
	Revision 1.1  2004/12/14 00:25:34  crosser
	make configuration: options, limits etc.
	
*/

/*
	WHAT IS IT:
		modularized contentfilter for Zmailer
	COPYRIGHT:
		(c) 2003-2009 Eugene G. Crosser <crosser@average.org>
	LICENSE:
		The same set as apply to Zmailer code
*/

#include "config.h"

#ifdef STDC_HEADERS
# include <sys/types.h>
# include <stdio.h>
# include <stdlib.h>
# include <string.h>
#endif

#include <clamav.h>
#include "clamav_config.h"
#include "zmscanner.h"
#include "report.h"

#ifndef offsetof
# define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif

static long long getnum(char *p)
{
	long long factor;
	char *q=p+strlen(p)-1;

	switch (*q) {
	case 'k':
	case 'K':
		factor=1024;
		*q='\0';
		break;
	case 'm':
	case 'M':
		factor=1024*1024;
		*q='\0';
		break;
	default:
		factor=1;
		break;
	}
	return factor*atol(p);
}

static struct _opts {
	char *verb;
	int flag;
} opts[] = {
	{"archive",			CL_SCAN_ARCHIVE},
	{"blockbroken",			CL_SCAN_BLOCKBROKEN},
	{"blockencrypted",		CL_SCAN_BLOCKENCRYPTED},
	{"blockmax",			CL_SCAN_BLOCKMAX},
#ifdef CL_SCAN_DISABLERAR
	{"disablerar",			CL_SCAN_DISABLERAR},
#endif
	{"html",			CL_SCAN_HTML},
	{"ole2",			CL_SCAN_OLE2},
	{"pe",				CL_SCAN_PE},
#ifdef CL_SCAN_ELF
	{"elf",				CL_SCAN_ELF},
#endif
#ifdef CL_SCAN_ALGO
	{"algo",			CL_SCAN_ALGO},
#elif CL_SCAN_ALGORITHMIC
	{"algo",			CL_SCAN_ALGORITHMIC},
#endif
#ifdef CL_SCAN_MAILURL
	{"mailurl",			CL_SCAN_MAILURL},
#endif
#ifdef CL_SCAN_NOPHISHING
	{"nophishing",			CL_SCAN_NOPHISHING},
#endif
#ifdef CL_PHISH_NO_DOMAINLIST
	{"nodomainlist",		CL_PHISH_NO_DOMAINLIST},
#endif
#ifdef CL_SCAN_PHISHING_DOMAINLIST
	{"domainlist",			CL_SCAN_PHISHING_DOMAINLIST},
#endif
#ifdef CL_SCAN_PHISHING_BLOCKSSL
	{"blockssl",			CL_SCAN_PHISHING_BLOCKSSL},
#endif
#ifdef CL_SCAN_PHISHING_BLOCKCLOAK
	{"blockcloak",			CL_SCAN_PHISHING_BLOCKCLOAK},
#endif
#ifdef CL_SCAN_PDF
	{"pdf",				CL_SCAN_PDF},
#endif
#ifdef CL_SCAN_STRUCTURED
	{"structured",			CL_SCAN_STRUCTURED},
#endif
#ifdef CL_SCAN_STRUCTURED_SSN_NORMAL
	{"structured-ssn-normal",	CL_SCAN_STRUCTURED_SSN_NORMAL},
#endif
#ifdef CL_SCAN_STRUCTURED_SSN_STRIPPED
	{"structured-ssn-stripped",	CL_SCAN_STRUCTURED_SSN_STRIPPED},
#endif
#ifdef CL_SCAN_PARTIAL_MESSAGE
	{"partial-message",		CL_SCAN_PARTIAL_MESSAGE},
#endif
#ifdef CL_SCAN_HEURISTIC_PRECEDENCE
	{"heuristic-precedence",	CL_SCAN_HEURISTIC_PRECEDENCE},
#endif
	{NULL,			0}
};

unsigned int
verb_options(char *data,char *fn,int count)
{
	unsigned int options=0;
	char *p,*q;
	int up;
	int i;

	DPRINT(("parsing options \"%s\"\n",data));
	options=CL_SCAN_STDOPT & ~CL_SCAN_MAIL;
	for (p=data;*p;) {
		for (q=p;(*q != '\0') && (*q != ' ') && (*q != ',');q++) ;
		if (*q != '\0') *q++='\0';
		while (*q && (*q == ' ')) q++;
		DPRINT(("option \"%s\"\n",p));
		if (*p == '+') { up=1; p++; }
		else if (*p == '-') { up=0; p++; }
		else { up=1; }
		for (i=0;opts[i].verb;i++) {
			if (strcasecmp(p,opts[i].verb) == 0) break;
		}
		if (opts[i].verb) {
			if (up) options |= opts[i].flag;
			else options &= ~opts[i].flag;
		} else {
			ERRLOG((LOG_ERR,"%s(%d): unknown option %s",
								fn,count,p));
		}
		p=q;
	}
	return options;
}

#ifdef HAVE_CL_INIT
static void
set_pua_opts(clamav_cfg_t *cfg,struct cl_engine *engine,char *data,
							char *fn, int count)
{
	char *p,*q;
	int rc;
	char *pua_cats;

	DPRINT(("parsing PUA options \"%s\"\n",data));

	p=data;
	switch (*p) {
	case '*':
		cfg->dbopts |= CL_DB_PUA;
		if (*(p+1))
			ERRLOG((LOG_ERR,"%s(%d): PUA args after '*' ignored",
								fn,count));
		return;
	case '+':
		cfg->dbopts |= (CL_DB_PUA | CL_DB_PUA_INCLUDE);
		break;
	case '-':
		cfg->dbopts |= (CL_DB_PUA | CL_DB_PUA_EXCLUDE);
		break;
	default:
		ERRLOG((LOG_ERR,"%s(%d): PUA arg \"%s\" is not '*'|'+'|'-'",
								fn,count,p));
		return;
	}

	if ((pua_cats=(char *)malloc(strlen(data)+2)) == NULL) {
		ERRLOG((LOG_ERR,"%s(%d): cannot allocate memory: %m",fn,count));
		return;
	}
	p++;
	while (*p && (*p == ' ')) p++;
	while (*p) {
		for (q=p;(*q != '\0') && (*q != ' ') && (*q != ',');q++) ;
		if (*q != '\0') *q++='\0';
		while (*q && (*q == ' ')) q++;
		DPRINT(("PUA cat \"%s\"\n",p));
		strcat(pua_cats,".");
		strcat(pua_cats,p);
		p=q;
	}
	strcat(pua_cats,".");
	DPRINT(("setting PUA cats to \"%s\"\n",pua_cats));
	if ((rc=cl_engine_set_str(engine,CL_ENGINE_PUA_CATEGORIES,pua_cats)))
		ERRLOG((LOG_ERR,"%s(%d): set_str(\"%s\"): %s",
			fn,count,p,cl_strerror(rc)));
	free(pua_cats);
}
#endif

static struct _verbs {
	char *verb;
	enum {badverb,boolean,integer,string,options
#ifdef HAVE_CL_INIT
				,ev_bool,ev_int,ev_str,ev_pua
#else
# define ev_int integer
# define CL_ENGINE_MAX_FILES     offsetof(clamav_cfg_t,limits.maxfiles)
# define CL_ENGINE_MAX_FILESIZE  offsetof(clamav_cfg_t,limits.maxfilesize)
# define CL_ENGINE_MAX_RECURSION offsetof(clamav_cfg_t,limits.maxreclevel)
# define CL_ENGINE_MAX_SCANSIZE  offsetof(clamav_cfg_t,limits.maxscansize)
#endif
							} vtype;
	int where;
} verbs[] = {
	{"dbdir",	string,	offsetof(clamav_cfg_t,dbdir)},
	{"scantext",	boolean,offsetof(clamav_cfg_t,scantext)},
	{"filescan",	boolean,offsetof(clamav_cfg_t,filescan)},
	{"options",	options,offsetof(clamav_cfg_t,clamopts)},
	{"maxfiles",	ev_int,CL_ENGINE_MAX_FILES},
	{"maxfilesize",	ev_int,CL_ENGINE_MAX_FILESIZE},
	{"maxreclevel",	ev_int,CL_ENGINE_MAX_RECURSION},
#if !defined(HAVE_CL_INIT) && defined(HAVE_STRUCT_CL_LIMITS_MAXRATIO)
	{"maxratio",	integer,offsetof(clamav_cfg_t,limits.maxratio)},
#endif
#if defined(HAVE_CL_INIT) || defined(HAVE_STRUCT_CL_LIMITS_MAXSCANSIZE)
	{"maxscansize",	ev_int,CL_ENGINE_MAX_SCANSIZE},
#endif
#if !defined(HAVE_CL_INIT) && defined(HAVE_STRUCT_CL_LIMITS_ARCHIVEMEMLIM)
	{"archivememlim",integer,offsetof(clamav_cfg_t,limits.archivememlim)},
#endif
#ifdef HAVE_CL_INIT
	{"min-cc-count",ev_int,CL_ENGINE_MIN_CC_COUNT},
	{"min-ssn_-ount",ev_int,CL_ENGINE_MIN_SSN_COUNT},
	{"detectpua",	ev_pua,0},
	{"ac-only",	ev_int,CL_ENGINE_AC_ONLY},
	{"ac-mindepth",	ev_int,CL_ENGINE_AC_MINDEPTH},
	{"ac-maxdepth",	ev_int,CL_ENGINE_AC_MAXDEPTH},
	{"tmpdir",	ev_str,CL_ENGINE_TMPDIR},
	{"keeptmp",	ev_bool,CL_ENGINE_KEEPTMP},
#endif
#ifdef ev_int
# undef ev_int
#endif
	{NULL,		badverb,0}
};

clamav_cfg_t *
clamav_config(char *fn)
{
	clamav_cfg_t *cfg;
	FILE *fp;
	char buf[256];
	char fbuf[128];
	int count=0;
	int options_set=0;
#ifdef HAVE_CL_INIT
	struct cl_engine *tmpen;
#endif

	cfg=(clamav_cfg_t *)malloc(sizeof(clamav_cfg_t));
	memset(cfg,0,sizeof(clamav_cfg_t));
	cfg->clamopts=CL_SCAN_STDOPT & ~CL_SCAN_MAIL;

	snprintf(fbuf,sizeof(fbuf),"%s/%s",modconfdir(),fn);

	DPRINT(("clamav_config fn=%s\n",fn));

#ifdef HAVE_CL_INIT
	tmpen=cl_engine_new();
	if (tmpen == NULL) {
		fprintf(stderr,"cannot create temp engine\n");
		return cfg;
	}
#endif

	if ((fp=fopen(fn,"r")) == NULL) {
		perror(fn);
		return cfg;
	}
	while (fgets(buf,sizeof(buf)-1,fp)) {
		char *p;
		int i;
		int options_set=0;
		long long lvl;
		int rc;

		count++;
#if 0
		DPRINT(("clamav_config line %d: \"%s\"\n",count,buf));
#endif
		if (buf[0] == '#') continue;
		buf[sizeof(buf)-1]='\0';
		p=buf+strlen(buf)-1;
		while ((p >= buf) && ((*p == '\r') || (*p == '\n') ||
				     (*p == ' ') || (*p == '\t'))) *p--='\0';
		if (buf[0] == '\0') continue;
		for (p=buf;(*p != ' ') && (*p != '\t') && (*p != '\0');p++) ;
		*p++='\0';
		while ((*p == ' ') || (*p == '\t')) p++;
		for (i=0;verbs[i].verb;i++) {
			if (strcasecmp(verbs[i].verb,buf) == 0) break;
		}
		switch (verbs[i].vtype) {
		case boolean:
			DPRINT(("clamav_config bool \"%s\" - \"%s\"\n",
					verbs[i].verb,p));
			if ((strcasecmp(p,"yes") == 0) ||
			    (strcasecmp(p,"on") == 0)) {
				*((int*)((char*)cfg+verbs[i].where))=1;
			} else if ((strcasecmp(p,"no") == 0) ||
				   (strcasecmp(p,"off") == 0)) {
				*((int*)((char*)cfg+verbs[i].where))=0;
			} else {
				ERRLOG((LOG_ERR,"%s(%d): bad boolean \"%s\"",
					fn,count,p));
			}
			break;
		case integer:
			DPRINT(("clamav_config int \"%s\" - \"%s\"\n",
					verbs[i].verb,p));
			*((int*)((char*)cfg+verbs[i].where))=(int)getnum(p);
			break;
		case string:
			*((char**)((char*)cfg+verbs[i].where))=
						(char*)malloc(strlen(p)+1);
			strcpy(*((char**)((char*)cfg+verbs[i].where)),p);
			break;
		case options:
			options_set=1;
			*((unsigned int*)((char*)cfg+verbs[i].where))=
					verb_options(p,fn,count);
			break;
#ifdef HAVE_CL_INIT
		case ev_bool:
			DPRINT(("clamav_config ev_bool \"%s\" - \"%s\"\n",
					verbs[i].verb,p));
			if ((strcasecmp(p,"yes") == 0) ||
			    (strcasecmp(p,"on") == 0)) {
				lvl=1ll;
			} else if ((strcasecmp(p,"no") == 0) ||
				   (strcasecmp(p,"off") == 0)) {
				lvl=0ll;
			} else {
				ERRLOG((LOG_ERR,"%s(%d): bad boolean \"%s\"",
					fn,count,p));
				break;
			}
			if ((rc=cl_engine_set_num(tmpen,verbs[i].where,lvl)))
				ERRLOG((LOG_ERR,"%s(%d): set_num(\"%s\"): %s",
					fn,count,p,cl_strerror(rc)));
			break;
		case ev_int:
			DPRINT(("clamav_config ev_int \"%s\" - \"%s\"\n",
					verbs[i].verb,p));
			if ((rc=cl_engine_set_num(tmpen,verbs[i].where,
						getnum(p))))
				ERRLOG((LOG_ERR,"%s(%d): set_num(\"%s\"): %s",
					fn,count,p,cl_strerror(rc)));
			break;
		case ev_str:
			if ((rc=cl_engine_set_str(tmpen,verbs[i].where,p)))
				ERRLOG((LOG_ERR,"%s(%d): set_str(\"%s\"): %s",
					fn,count,p,cl_strerror(rc)));
			break;
		case ev_pua:
			set_pua_opts(cfg,tmpen,p,fn,count);
			break;
#endif
		case badverb:
			ERRLOG((LOG_ERR,"%s(%d): bad verb \"%s\"",
					fn,count,buf));
			break;
		}
	}
	fclose(fp);
#ifdef HAVE_CL_INIT
	cfg->settings=cl_engine_settings_copy(tmpen);
	cl_engine_free(tmpen);
#endif
#ifndef HAVE_CL_SCANBUFF
	if (!cfg->filescan) {
		ERRLOG((LOG_ERR,"clamav: this version of clamav does not "
				"support scanning memory buffers, "
				"'filescan' option force set to 'on'"));
		cfg->filescan=1;
	}
#endif
	if (options_set && !cfg->filescan) {
		ERRLOG((LOG_ERR,"clamav: filescan is false, "
				"options will be ignored"));
	}
#ifdef CL_DB_STDOPT
	cfg->dbopts=CL_DB_STDOPT;
#else
	cfg->dbopts=0;
#endif
#ifdef CL_DB_PHISHING
	if (cfg->clamopts & (0
#ifdef CL_SCAN_PHISHING_DOMAINLIST
				| CL_SCAN_PHISHING_DOMAINLIST
#endif
#ifdef CL_SCAN_PHISHING_BLOCKSSL
				| CL_SCAN_PHISHING_BLOCKSSL
#endif
#ifdef CL_SCAN_PHISHING_BLOCKCLOAK
				| CL_SCAN_PHISHING_BLOCKCLOAK
#endif
								)) {
		cfg->dbopts |= CL_DB_PHISHING
#ifdef CL_DB_PHISHING_URLS
				| CL_DB_PHISHING_URLS
#endif
							;
	}
#endif /* CL_DB_PHISHING */
	DPRINT(("clamav cfg dbdir=%s\n",cfg->dbdir));
	DPRINT(("clamav cfg filescan=%d\n",cfg->filescan));
	DPRINT(("clamav cfg options=0x%08x\n",cfg->clamopts));
	DPRINT(("clamav cfg dboptions=0x%08x\n",cfg->dbopts));
	return cfg;
}
